package org.mulesoft.apb.project.internal.parser

import amf.aml.client.scala.model.document.{Dialect, kind}
import amf.aml.internal.parse.hints.Guess
import amf.aml.internal.parse.plugin.AMLDialectInstanceParsingPlugin
import amf.core.client.scala.parse.AMFParsePlugin
import amf.core.internal.parser.Root
import org.mulesoft.apb.project.internal.generated.AnypointDescriptorDialectLoader

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

case class AMLDescriptorPlugin(override val dialect: Dialect) extends AMLDialectInstanceParsingPlugin(dialect) {
  override protected def guess: Guess[kind.DialectInstanceDocumentKind] = HardCodedDialectInstanceGuess()
}

object AMLDescriptorPlugin {
  def apply(version: String): Future[AMFParsePlugin] = {
    AnypointDescriptorDialectLoader.dialect(version).map { dialect =>
      AMLDescriptorPlugin(dialect)
    }
  }
}

case class HardCodedDialectInstanceGuess() extends Guess[kind.DialectInstanceDocumentKind] {
  override def hint(root: Root): Option[String] = Some("") // Not necessary as we will always parse a DialectInstance

  override def from(root: Root): Option[kind.DialectInstanceDocumentKind] = Some(kind.DialectInstance)
}
