package org.mulesoft.apb.project.internal.generated

import amf.aml.client.scala.AMLConfiguration
import amf.aml.client.scala.model.document.Dialect
import amf.core.client.scala.AMFResult
import amf.core.client.scala.validation.AMFValidationResult

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

object AnypointDescriptorDialectLoader {

  private val client = AMLConfiguration
    .predefined()
    .baseUnitClient()

  val `VERSION_0.1.0` = "0.1.0"
  val `VERSION_1.0.0` = "1.0.0"

  val contents = Map(
      `VERSION_0.1.0` -> AnypointDescriptorDialect_0_1_0.content,
      `VERSION_1.0.0` -> AnypointDescriptorDialect_1_0_0.content
  )

  val transformedDialects: Map[String, Future[AMFResult]] = contents.map { case (key, value) =>
    key -> transformDialect(value)
  }

  def allErrors: Future[Seq[AMFValidationResult]] =
    Future.sequence(transformedDialects.values).map(_.toSeq.flatMap(_.results))
  def errors(version: String): Future[Seq[AMFValidationResult]] = transformedDialects(version).map(_.results)
  def dialect(version: String): Future[Dialect] = transformedDialects(version).map(_.baseUnit.asInstanceOf[Dialect])

  private def transformDialect(content: String): Future[AMFResult] = client
    .parseContent(content)
    .map { x =>
      val transformed = client.transform(x.baseUnit)
      transformed.copy(results = transformed.results ++ x.results)
    }
}
