package org.mulesoft.apb.project.client.scala

import amf.core.client.scala.validation.{AMFValidationReport, AMFValidationResult}

case class ProjectErrors(treeErrors: List[AMFValidationResult] = Nil, projectErrors: List[AMFValidationResult] = Nil) {
  private[apb] def addTreeErrors(errors: List[AMFValidationResult]) = copy(treeErrors = treeErrors ++ errors)

  private[apb] def addProjectError(error: AMFValidationResult) = copy(projectErrors = error :: projectErrors)

  private[apb] def addProjectErrors(report: AMFValidationReport) =
    copy(projectErrors = report.results.toList ::: projectErrors)

  private[apb] def addProjectErrors(errors: List[AMFValidationResult]) = copy(projectErrors = errors ::: projectErrors)

  private[apb] def add(errors: ProjectErrors): ProjectErrors =
    copy(treeErrors = this.treeErrors ++ errors.treeErrors, projectErrors = this.projectErrors ++ errors.projectErrors)

  private[apb] def allErrors: List[AMFValidationResult] = treeErrors ::: projectErrors
}
