package org.mulesoft.apb.project.client.scala.dependency

import amf.core.client.scala.adoption.{DefaultIdMaker, IdAdopter, IdAdopterProvider, IdMaker}
import amf.core.client.scala.model.document.BaseUnit
import amf.core.client.scala.model.domain.{AmfArray, AmfObject}
import amf.core.internal.adoption.BaseUnitFieldAdoptionOrdering
import amf.core.internal.metamodel.document.DocumentModel
import amf.core.internal.parser.domain.FieldEntry

import scala.collection.mutable

class APBIdAdopterProvider private (adoptedDependencies: mutable.Map[String, AmfObject]) extends IdAdopterProvider {
  override def idAdopter(initialId: String): IdAdopter = new IdAdopter(initialId, adopted = adoptedDependencies)

  override def idAdopter(initialId: String, idMaker: IdMaker): IdAdopter =
    new IdAdopter(initialId, idMaker, adopted = adoptedDependencies)
}

object APBIdAdopterProvider {
  def apply(designDependencies: Seq[DesignDependency]): APBIdAdopterProvider = {
    val map = mutable.Map[String, AmfObject]()
    designDependencies.foreach { dd => map.put(dd.baseUnit.id, dd.baseUnit) }
    new APBIdAdopterProvider(map)
  }
}
