package org.mulesoft.apb.project.client.platform.model

import amf.apicontract.internal.convert.ApiClientConverters.{ClientList, ClientOption}
import org.mulesoft.apb.project.client.scala.model.{
  DependencyScope,
  Gav => InternalGav,
  MetadataElement => InternalMetadataElement,
  ProjectDependency => InternalProjectDependency,
  ProjectDescriptor => InternalProjectDescriptor
}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class ProjectDescriptor private[apb] (private[apb] val _internal: InternalProjectDescriptor) {

  val main: String                                = _internal.main
  val name: String                                = _internal.name
  val gav: Gav                                    = _internal.gav
  val classifier: ClientOption[String]            = _internal.classifier.asClient
  val tags: ClientList[String]                    = _internal.tags.asClient
  val apiVersion: ClientOption[String]            = _internal.apiVersion.asClient
  val organizationId: ClientOption[String]        = _internal.organizationId.asClient
  val originalFormatVersion: ClientOption[String] = _internal.originalFormatVersion.asClient
  val metadata: ClientOption[MetadataElement]     = _internal.metadata.asClient
  val backwardsCompatible: ClientOption[Boolean]  = _internal.backwardsCompatible.asClient
  val publishWithRefFiles: ClientOption[Boolean]  = _internal.publishWithRefFiles.asClient
  val description: ClientOption[String]           = _internal.description.asClient
  val projectId: ClientOption[String]             = _internal.projectId.asClient
  val dependencies: ClientList[ProjectDependency] = _internal.dependencies.asClient
  val descriptorVersion: String                   = _internal.descriptorVersion

  def isLegacyDescriptor: Boolean = _internal.isLegacyDescriptor
}

@JSExportAll
case class Gav private[apb] (private[apb] val _internal: InternalGav) {

  @JSExportTopLevel("Gav")
  def this(groupId: String, assetId: String, version: String) = this(InternalGav(groupId, assetId, version))

  val groupId: String = _internal.groupId
  val assetId: String = _internal.assetId
  val version: String = _internal.version

  val path: String = _internal.path
}

@JSExportAll
case class ProjectDependency private[apb] (private[apb] val _internal: InternalProjectDependency) {

  @JSExportTopLevel("ProjectDependency")
  def this(
      scope: DependencyScope,
      gav: Gav,
      hasExplicitScope: Boolean,
      shouldBeProvided: Boolean,
      parentClassifier: ClientOption[String],
      classifier: ClientOption[String],
      packaging: ClientOption[String]
  ) =
    this(
        InternalProjectDependency(
            scope,
            gav._internal,
            hasExplicitScope,
            shouldBeProvided,
            parentClassifier.toScala,
            classifier.toScala,
            packaging.toScala
        )
    )

  val gav: Gav                               = GavMatcher.asClient(_internal.gav)
  val scope: DependencyScope                 = _internal.scope
  val hasExplicitScope: Boolean              = _internal.hasExplicitScope
  val shouldBeProvided: Boolean              = _internal.shouldBeProvided
  val parentClassifier: ClientOption[String] = _internal.parentClassifier.asClient
  val classifier: ClientOption[String]       = _internal.classifier.asClient
  val packaging: ClientOption[String]        = _internal.packaging.asClient

  val absolutePath: String = _internal.absolutePath
}

@JSExportAll
case class MetadataElement private[apb] (private[apb] val _internal: InternalMetadataElement) {

  @JSExportTopLevel("MetadataElement")
  def this(branchId: ClientOption[String], commitId: ClientOption[String], projectId: ClientOption[String]) =
    this(InternalMetadataElement(branchId.toScala, commitId.toScala, projectId.toScala))

  val branchId: ClientOption[String]  = _internal.branchId.asClient
  val commitId: ClientOption[String]  = _internal.commitId.asClient
  val projectId: ClientOption[String] = _internal.projectId.asClient
}
