package org.mulesoft.apb.project.internal.convert

import amf.apicontract.internal.convert.ApiBaseClientConverter
import amf.core.client.platform.resource
import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.convert.{BidirectionalMatcher, InternalClientMatcher}
import org.mulesoft.apb.project.client.platform.dependency.{
  DesignDependency => ClientDesignDependency,
  ExtensionDependency => ClientExtensionDependency,
  ParsedDependency => ClientParsedDependency,
  ProfileDependency => ClientProfileDependency
}
import org.mulesoft.apb.project.client.platform.descriptor.{
  DescriptorParseResult => ClientDescriptorParseResult,
  ExchangeDescriptorBuilder => ClientExchangeDescriptorBuilder
}
import org.mulesoft.apb.project.client.platform.environment.{DependencyFetcher => ClientDependencyFetcher}
import org.mulesoft.apb.project.client.platform.model.{
  Gav => ClientGav,
  MetadataElement => ClientMetadataElement,
  ProjectDependency => ClientProjectDependency,
  ProjectDescriptor => ClientProjectDescriptor
}
import org.mulesoft.apb.project.client.platform.{ProjectConfiguration => ClientProjectConfiguration}
import org.mulesoft.apb.project.client.scala.ProjectConfiguration
import org.mulesoft.apb.project.client.scala.dependency.{
  DesignDependency,
  ExtensionDependency,
  ParsedDependency,
  ProfileDependency
}
import org.mulesoft.apb.project.client.scala.descriptor.{DescriptorParseResult, ExchangeDescriptorBuilder}
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.model.{Gav, MetadataElement, ProjectDependency, ProjectDescriptor}

import scala.concurrent.{ExecutionContext, Future}

trait APBProjectConverters extends ApiBaseClientConverter {
  implicit class FutureListConverter[Internal, Client](from: Future[Seq[Internal]])(implicit
      m: InternalClientMatcher[Internal, Client],
      executionContext: ExecutionContext
  ) {
    def asClient: ClientFuture[ClientList[Client]] = {
      asClientFuture(from.map(s => asClientList(s, m)))
    }
  }

  implicit object ProjectConfigurationClientConverter
      extends InternalClientMatcher[ProjectConfiguration, ClientProjectConfiguration] {
    override def asClient(from: ProjectConfiguration): ClientProjectConfiguration =
      new ClientProjectConfiguration(from)
  }

  implicit object DependencyFetcherConverter extends BidirectionalMatcher[DependencyFetcher, ClientDependencyFetcher] {
    override def asInternal(from: ClientDependencyFetcher): DependencyFetcher = new DependencyFetcher {
      override def accepts(groupId: String, assetId: String, version: String): Boolean =
        from.accepts(groupId, assetId, version)

      override def fetch(groupId: String, assetId: String, version: String): ResourceLoader =
        ResourceLoaderMatcher.asInternal(from.fetch(groupId, assetId, version))(ExecutionContext.Implicits.global)

      override def accepts(
          groupId: String,
          assetId: String,
          version: String,
          classifier: Option[String],
          packaging: Option[String]
      ): Boolean =
        from.accepts(groupId, assetId, version, classifier.asClient, packaging.asClient)

      override def fetch(
          groupId: String,
          assetId: String,
          version: String,
          classifier: Option[String],
          packaging: Option[String]
      ): ResourceLoader =
        ResourceLoaderMatcher.asInternal(
            from.fetch(groupId, assetId, version, classifier.asClient, packaging.asClient)
        )(ExecutionContext.Implicits.global)
    }

    override def asClient(from: DependencyFetcher): ClientDependencyFetcher = new ClientDependencyFetcher {
      import scala.concurrent.ExecutionContext.Implicits.global

      override def accepts(groupId: String, assetId: String, version: String): Boolean =
        from.accepts(groupId, assetId, version)

      override def accepts(
          groupId: String,
          assetId: String,
          version: String,
          classifier: ClientOption[String],
          packaging: ClientOption[String]
      ): Boolean =
        from.accepts(groupId, assetId, version, classifier.toScala, packaging.toScala)

      override def fetch(groupId: String, assetId: String, version: String): resource.ResourceLoader =
        ResourceLoaderMatcher.asClient(from.fetch(groupId, assetId, version))

      override def fetch(
          groupId: String,
          assetId: String,
          version: String,
          classifier: ClientOption[String],
          packaging: ClientOption[String]
      ): resource.ResourceLoader =
        ResourceLoaderMatcher.asClient(from.fetch(groupId, assetId, version, classifier.toScala, packaging.toScala))

    }
  }

  implicit object ParsedDependencyConverter extends InternalClientMatcher[ParsedDependency, ClientParsedDependency] {
    override def asClient(from: ParsedDependency): ClientParsedDependency = from match {
      case d: DesignDependency    => ClientDesignDependency(d)
      case e: ExtensionDependency => ClientExtensionDependency(e)
      case p: ProfileDependency   => ClientProfileDependency(p)
    }
  }

  implicit object DesignDependencyConverter extends BidirectionalMatcher[DesignDependency, ClientDesignDependency] {
    override def asClient(from: DesignDependency): ClientDesignDependency   = ClientDesignDependency(from)
    override def asInternal(from: ClientDesignDependency): DesignDependency = from._internal
  }

  implicit object ExtensionDependencyConverter
      extends BidirectionalMatcher[ExtensionDependency, ClientExtensionDependency] {
    override def asClient(from: ExtensionDependency): ClientExtensionDependency   = ClientExtensionDependency(from)
    override def asInternal(from: ClientExtensionDependency): ExtensionDependency = from._internal
  }

  implicit object ProfileDependencyConverter extends BidirectionalMatcher[ProfileDependency, ClientProfileDependency] {
    override def asClient(from: ProfileDependency): ClientProfileDependency   = ClientProfileDependency(from)
    override def asInternal(from: ClientProfileDependency): ProfileDependency = from._internal
  }

  implicit object ProjectDescriptorConverter extends BidirectionalMatcher[ProjectDescriptor, ClientProjectDescriptor] {
    override def asClient(from: ProjectDescriptor): ClientProjectDescriptor   = ClientProjectDescriptor(from)
    override def asInternal(from: ClientProjectDescriptor): ProjectDescriptor = from._internal
  }

  implicit object GavMatcher extends BidirectionalMatcher[Gav, ClientGav] {
    override def asClient(from: Gav): ClientGav   = ClientGav(from)
    override def asInternal(from: ClientGav): Gav = from._internal
  }

  implicit object MetadataElementMatcher extends BidirectionalMatcher[MetadataElement, ClientMetadataElement] {
    override def asClient(from: MetadataElement): ClientMetadataElement   = ClientMetadataElement(from)
    override def asInternal(from: ClientMetadataElement): MetadataElement = from._internal
  }

  implicit object ProjectDependencyMatcher extends BidirectionalMatcher[ProjectDependency, ClientProjectDependency] {
    override def asClient(from: ProjectDependency): ClientProjectDependency   = ClientProjectDependency(from)
    override def asInternal(from: ClientProjectDependency): ProjectDependency = from._internal
  }

  implicit object ExchangeDescriptorBuilderMatcher
      extends BidirectionalMatcher[ExchangeDescriptorBuilder, ClientExchangeDescriptorBuilder] {
    override def asClient(from: ExchangeDescriptorBuilder): ClientExchangeDescriptorBuilder =
      ClientExchangeDescriptorBuilder(from)
    override def asInternal(from: ClientExchangeDescriptorBuilder): ExchangeDescriptorBuilder = from._internal
  }

  implicit object DescriptorParseResultMatcher
      extends BidirectionalMatcher[DescriptorParseResult, ClientDescriptorParseResult] {
    override def asClient(from: DescriptorParseResult): ClientDescriptorParseResult = ClientDescriptorParseResult(from)
    override def asInternal(from: ClientDescriptorParseResult): DescriptorParseResult = from._internal
  }
}

object APBProjectConverters extends APBProjectConverters
