/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.apb.project.internal.engine;

import amf.core.client.common.validation.SeverityLevels$;
import amf.core.client.scala.validation.AMFValidationResult;
import amf.core.client.scala.validation.AMFValidationResult$;
import java.io.Serializable;
import org.mulesoft.apb.project.client.scala.ProjectErrors;
import org.mulesoft.apb.project.client.scala.ProjectErrors$;
import org.mulesoft.apb.project.client.scala.dependency.Dependency;
import org.mulesoft.apb.project.client.scala.dependency.ParsedDependency;
import org.mulesoft.apb.project.client.scala.dependency.ProvidedDependency;
import org.mulesoft.apb.project.client.scala.model.DependencyScope;
import org.mulesoft.apb.project.client.scala.model.ExtensionScope$;
import org.mulesoft.apb.project.client.scala.model.Gav;
import org.mulesoft.apb.project.client.scala.model.ProjectDependency;
import org.mulesoft.apb.project.internal.validations.ProjectValidations$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxesRunTime;

public final class SuggestedExtensionAdditions$ {
    public static SuggestedExtensionAdditions$ MODULE$;

    static {
        new SuggestedExtensionAdditions$();
    }

    public ProjectErrors apply(Gav project, Seq<ParsedDependency> dependencies) {
        Map<Gav, Set<Tuple2<Gav, DependencyScope>>> notPresentExtensionsByProfile = this.buildSuggestedExtensionByProfile(dependencies);
        List<AMFValidationResult> results = this.createErrorResults(project, notPresentExtensionsByProfile);
        return new ProjectErrors(ProjectErrors$.MODULE$.apply$default$1(), ProjectErrors$.MODULE$.apply$default$2()).addProjectErrors(results);
    }

    private List<AMFValidationResult> createErrorResults(Gav project, Map<Gav, Set<Tuple2<Gav, DependencyScope>>> notPresentExtensionsByProfile) {
        return ((TraversableOnce)notPresentExtensionsByProfile.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Gav profileGav = (Gav)tuple2._1();
                Set extensionGavs = (Set)tuple2._2();
                return (Set)extensionGavs.map((Function1 & Serializable & scala.Serializable)extensionGav -> MODULE$.suggestion(project, profileGav, (Gav)extensionGav._1(), (DependencyScope)extensionGav._2()), Set$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toList();
    }

    private Map<Gav, Set<Tuple2<Gav, DependencyScope>>> buildSuggestedExtensionByProfile(Seq<ParsedDependency> currentDependencies) {
        Set projectExtensionGavs = ((TraversableOnce)currentDependencies.map((Function1 & Serializable & scala.Serializable)d -> new Tuple2((Object)d.descriptor().gav(), (Object)d.scope()), Seq$.MODULE$.canBuildFrom())).toSet();
        Map extensionsUsedByEachProfile = ((TraversableOnce)currentDependencies.map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.descriptor().gav()), MODULE$.getProvidedExtensions((Dependency)p)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map notPresentExtensionsByProfile = extensionsUsedByEachProfile.mapValues((Function1 & Serializable & scala.Serializable)x -> (Set)x.diff((GenSet)projectExtensionGavs));
        return notPresentExtensionsByProfile;
    }

    private String suggestedExtensionMessage(Gav profileGav, Gav extensionGav, DependencyScope scope) {
        return new StringBuilder(64).append(scope.scope()).append(" dependency: ").append(extensionGav.path()).append(" should be added when using validation dependency: ").append(profileGav.path()).toString();
    }

    private Seq<ProjectDependency> filterExtensionDependencies(Dependency dependency) {
        return (Seq)dependency.descriptor().dependencies().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)SuggestedExtensionAdditions$.$anonfun$filterExtensionDependencies$1(p)));
    }

    private Set<Tuple2<Gav, DependencyScope>> getProvidedExtensions(Dependency dependency) {
        return ((TraversableOnce)((TraversableLike)this.filterExtensionDependencies(dependency).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)x.shouldBeProvided()))).map((Function1 & Serializable & scala.Serializable)d -> new Tuple2((Object)d.gav(), (Object)d.scope()), Seq$.MODULE$.canBuildFrom())).toSet();
    }

    private AMFValidationResult suggestion(Gav project, Gav dependency, Gav provided, DependencyScope scope) {
        return AMFValidationResult$.MODULE$.apply(this.suggestedExtensionMessage(dependency, provided, scope), SeverityLevels$.MODULE$.WARNING(), "", (Option)None$.MODULE$, ProjectValidations$.MODULE$.SuggestedExtensionDependency().id(), (Option)None$.MODULE$, (Option)new Some((Object)project.path()), (Object)new ProvidedDependency(dependency, provided, scope));
    }

    public static final /* synthetic */ boolean $anonfun$filterExtensionDependencies$1(ProjectDependency p) {
        DependencyScope dependencyScope = p.scope();
        ExtensionScope$ extensionScope$ = ExtensionScope$.MODULE$;
        return !(dependencyScope != null ? !((Object)dependencyScope).equals(extensionScope$) : extensionScope$ != null);
    }

    private SuggestedExtensionAdditions$() {
        MODULE$ = this;
    }
}

