package org.mulesoft.apb.project.internal.model.project

import amf.core.client.scala.model.document.{BaseUnit, EncodesModel}
import amf.core.internal.metamodel.document.BaseUnitModel
import amf.core.internal.metamodel.document.DocumentModel.Encodes
import amf.core.internal.parser.domain.{Annotations, Fields}
import org.mulesoft.apb.project.client.scala.model.project.ProjectInfo
import org.mulesoft.apb.project.internal.metamodel.ProjectDocumentModel

class ProjectDocument(override val fields: Fields, override val annotations: Annotations)
    extends BaseUnit
    with EncodesModel {

  /** Meta data for the document */
  override def meta: BaseUnitModel = ProjectDocumentModel

  /** Returns the list document URIs referenced from the document that has been parsed to generate this model */
  override def references: Seq[BaseUnit] = Nil

  /** Encoded DomainElement described in the document element. */
  override def encodes: ProjectInfo = fields(Encodes)

  /** Value , path + field value that is used to compose the id when the object its adopted */
  override def componentId: String = "project"
}

object ProjectDocument {
  def apply() = new ProjectDocument(Fields(), Annotations())
}
