package org.mulesoft.apb.project.client.scala.descriptor

import amf.core.internal.metamodel.Field
import amf.shapes.client.scala.config.JsonLDSchemaConfiguration
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptor
import org.yaml.render.JsonRender

object APBDescriptorRender {

  def render(descriptor: ProjectDescriptor): String = {
    val node = JsonLDSchemaConfiguration.JsonLDSchema().elementClient().renderElement(descriptor.wrapped, Nil);
    JsonRender.render(node)
  }

  private def iri(field: Field) = field.value.iri()
}
