package org.mulesoft.apb.project.client.scala.instances

import amf.core.client.scala.model.domain.DomainElement
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.metamodel.{Field, Type}
import amf.shapes.client.scala.model.document.JsonLDInstanceDocument
import amf.shapes.client.scala.model.domain.jsonldinstance.{JsonLDArray, JsonLDObject}
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDElementModel
import org.mulesoft.apb.project.internal.schema.JsonLdObjectOps

class APIInstanceBuilder(instances: List[JsonLDInstanceDocument]) {

  private val BASE              = "http://anypoint.com/vocabs/management#"
  private val API_INSTANCE_TERM = BASE + "APIInstance"
  private val PoliciesField = Field(
      Type.Array(JsonLDElementModel),
      ValueType(BASE + "policies"),
      ModelDoc(
          displayName = "policies"
      )
  )

  private def isApiInstanceNode(encodes: DomainElement) = encodes.meta.typeIris.contains(API_INSTANCE_TERM)

  private def isApiInstance(encodesModel: JsonLDInstanceDocument) = {
    encodesModel.encodes.length < 2 && encodesModel.encodes.exists({
      case e: DomainElement => isApiInstanceNode(e)
      case _                => false
    })
  }

  def build(): DomainElement = {
    val (apiInstances, bindings) = instances.partition(isApiInstance)
    // TODO: native-jsonld-schema validate that api instances are just one
    val apiInstance = apiInstances.head

    // TODO: native-jsonld-schema filter policyBinding class terms?
    val objects: List[JsonLDObject] = bindings.flatMap(_.encodes.collectFirst({ case jsonLdObject: JsonLDObject =>
      jsonLdObject
    }))

    JsonLdObjectOps.addProperty(apiInstance.encodes.head.asInstanceOf[JsonLDObject], PoliciesField, buildArray(objects))
  }

  private def buildArray(objects: List[JsonLDObject]) = {
    val array = new JsonLDArray()
    objects.foreach(array += _)
    array
  }

}
