package org.mulesoft.apb.project.client.scala.model

import amf.aml.client.scala.model.domain.DialectDomainElement
import amf.core.client.scala.model.StrField
import amf.core.client.scala.model.domain.{AmfObject, AmfScalar, Graph}
import amf.core.client.scala.vocabulary.Namespace.Data
import amf.core.internal.metamodel.Type.Str
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.metamodel.{Field, ModelDefaultBuilder, Obj}
import amf.core.internal.parser.domain.{Annotations, Fields}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.InstanceModel.{DefinedBy, GCL}
import org.mulesoft.apb.project.internal.ops.FieldsOps

object InstanceModel {

  val GCL       = Field(Str, Data + "gcl", doc("gcl"))
  val DefinedBy = Field(Str, Data + "definedBy", doc("definedBy"))

  val `type`              = List(Data + "APIInstance")
  def fields: List[Field] = List(GCL, DefinedBy)

  private def doc(name: String) = ModelDoc(displayName = name)

  val entityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}

case class Instance private[apb] (override private[apb] val wrapped: JsonLDObject) extends JsonLDObjectWrapper {

  override type This = Instance
  override protected def copy(newWrapped: JsonLDObject): Instance = Instance(newWrapped)

  lazy val gcl: String                        = get[StrField](GCL)
  lazy val definedBy: Option[String]          = get[StrField](DefinedBy)
  def withDefinedBy(schema: String): Instance = copy(wrapped.withProperty(DefinedBy, schema))
}

object Instance {
  def apply(gcl: String): Instance = Instance(
      JsonLDObject.empty(InstanceModel.entityModel, JsonPath.empty).set(GCL, gcl)
  )

}
