package org.mulesoft.apb.project.client.scala.model

import amf.core.client.scala.model.{BoolField, StrField}
import amf.core.client.scala.vocabulary.Namespace
import amf.core.internal.metamodel.Field
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptorModel.ProjectId

import scala.language.implicitConversions

trait JsonLDObjectWrapper {
  type This <: JsonLDObjectWrapper

  implicit protected def strOptFieldConversion(optField: StrField): Option[String] = optField.option()

  implicit protected def strFieldConversion(optField: StrField): String = optField.option().getOrElse("")

  implicit protected def boolOptFieldConversion(boolField: BoolField): Option[Boolean] = boolField.option()

  implicit protected def boolFieldConversion(boolField: BoolField): Boolean = boolField.option().getOrElse(false)

  implicit protected def strCollectionFieldConversion(collectionField: Seq[StrField]): Seq[String] =
    collectionField.flatMap(_.option())

  implicit protected def fieldToString(field: Field): String = field.toString

  private[apb] val wrapped: JsonLDObject
  protected def copy(newWrapped: JsonLDObject): This

  protected def get[T](field: Field): T = wrapped.fields.field(field)
  private val namespace: Namespace      = Namespace("http://anypoint.apb/vocabularies/dynamic#")

  def withDynamicProperty(key: String, value: String): This = copy(wrapped.withProperty((namespace + key).iri(), value))

  def withDynamicProperty(key: String, value: Int): This = copy(wrapped.withProperty((namespace + key).iri(), value))

  def withDynamicProperty(key: String, value: Boolean): This = copy(
      wrapped.withProperty((namespace + key).iri(), value)
  )

  def withDynamicProperty(key: String, value: Float): This = copy(wrapped.withProperty((namespace + key).iri(), value))

  def withDynamicProperty(key: String, value: JsonLDObject): This = copy(
      wrapped.withProperty((namespace + key).iri(), value)
  )

}
