package org.mulesoft.apb.project.client.scala.model

import amf.aml.client.scala.model.domain.DialectDomainElement
import amf.core.client.scala.model.{BoolField, StrField}
import amf.core.client.scala.model.domain.{AmfObject, AmfScalar, Graph}
import amf.core.client.scala.vocabulary.Namespace.Data
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Type.{Bool, Str}
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.metamodel.{Field, ModelDefaultBuilder, Obj}
import amf.core.internal.parser.domain.{Annotations, Fields, Value}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.ProjectDependencyModel.{
  AssetId,
  GroupId,
  Provided,
  Scope,
  Version,
  entityModel
}
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.{Anypoint, Catalog}
import org.mulesoft.apb.project.internal.ops.FieldsOps

import scala.language.implicitConversions

object ProjectDependencyModel {

  val GroupId  = Field(Str, Catalog + "groupId", doc("groupId"))
  val AssetId  = Field(Str, Catalog + "assetId", doc("assetId"))
  val Version  = Field(Str, Catalog + "version", doc("version"))
  val Scope    = Field(Str, Anypoint + "scope", doc("scope"))
  val Provided = Field(Bool, Anypoint + "provided", doc("provided"))

  val `type`: List[ValueType] = List(Catalog + "Dependency")

  private def doc(name: String) = ModelDoc(displayName = name)
  val fields: List[Field]       = List(GroupId, AssetId, Version, Scope, Provided)

  val entityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}
case class ProjectDependency private[apb] (override private[apb] val wrapped: JsonLDObject)
    extends JsonLDObjectWrapper
    with GavAware {

  override type This = ProjectDependency
  implicit def scopeToDependencyScope(strField: StrField): DependencyScope =
    strField.option().map(DependencyScope.apply).getOrElse(DesignScope)
  override protected def copy(newWrapped: JsonLDObject): ProjectDependency = ProjectDependency(newWrapped)
  override def gav: Gav                                                    = Gav(groupId, assetId, version)
  def groupId: String                                                      = get[StrField](GroupId)
  def assetId: String                                                      = get[StrField](AssetId)
  def version: String                                                      = get[StrField](Version)

  def hasExplicitScope: Boolean = {
    val value: StrField = get[StrField](Scope)
    value.option().isDefined
  }

  def shouldBeProvided: Boolean = get[BoolField](Provided)
  def scope: DependencyScope    = get[StrField](Scope)

  def absolutePath: String                                 = "/exchange_modules/" + gav.path + "exchange.json"
  def withScope(scope: DependencyScope): ProjectDependency = copy(wrapped.withProperty(Scope, scope.scope))
  def withProvided(provided: Boolean): ProjectDependency   = copy(wrapped.withProperty(Provided, provided))
}

object ProjectDependency {
  def apply(gav: Gav): ProjectDependency = {
    val dObject = JsonLDObject
      .empty(entityModel, JsonPath.empty)
      .set(GroupId, gav.groupId)
      .set(AssetId, gav.assetId)
      .set(Version, gav.version)
    ProjectDependency(dObject)
  }
}
