package org.mulesoft.apb.project.internal.generated

object DescriptorSchema {

  def schema: String = """{
                          |  "$schema": "https://json-schema.org/draft-07/schema",
                          |  "@context": {
                          |    "@base": "http://a.ml/vocabularies/data#",
                          |    "anypoint": "http://anypoint.com/vocabs/anypoint#",
                          |    "api": "http://anypoint.com/vocabs/api#",
                          |    "catalog": "http://anypoint.com/vocabs/digital-repository#",
                          |    "data": "http://a.ml/vocabularies/data#",
                          |    "scope": "anypoint:scope",
                          |    "provided": "anypoint:provided",
                          |    "instances": "api:instances",
                          |    "dependencies": "catalog:dependencies",
                          |    "organizationId": "anypoint:organizationId",
                          |    "branchId": "data:branchId",
                          |    "projectId": "data:projectId",
                          |    "commitId": "data:commitId",
                          |    "groupId": "catalog:groupId",
                          |    "assetId": "catalog:assetId",
                          |    "version": "catalog:version",
                          |    "gcl": "data:gcl",
                          |    "definedBy": "data:definedBy"
                          |  },
                          |  "required": [
                          |    "main",
                          |    "name"
                          |  ],
                          |  "properties": {
                          |    "main": {
                          |      "type": "string"
                          |    },
                          |    "name": {
                          |      "type": "string"
                          |    },
                          |    "classifier": {
                          |      "type": "string"
                          |    },
                          |    "tags": {
                          |      "type": "array",
                          |      "items": {
                          |        "type": "string"
                          |      }
                          |    },
                          |    "organizationId": {
                          |      "type": "string"
                          |    },
                          |    "apiVersion": {
                          |      "type": "string"
                          |    },
                          |    "originalFormatVersion": {
                          |      "type": "string"
                          |    },
                          |    "metadata": {
                          |      "$ref": "#/definitions/Metadata"
                          |    },
                          |    "backwardsCompatible": {
                          |      "type": "boolean"
                          |    },
                          |    "publishWithRefFiles": {
                          |      "type": "boolean"
                          |    },
                          |    "description": {
                          |      "type": "string"
                          |    },
                          |    "projectId": {
                          |      "type": "string"
                          |    }
                          |  },
                          |  "oneOf": [
                          |    {
                          |      "$ref": "#/definitions/Gav"
                          |    }
                          |  ],
                          |  "if": {
                          |    "required": [
                          |      "descriptorVersion"
                          |    ],
                          |    "properties": {
                          |      "descriptorVersion": {
                          |        "not": {
                          |          "const": "0.1.0"
                          |        }
                          |      }
                          |    }
                          |  },
                          |  "then": {
                          |    "@context": {
                          |      "instances": "api:instances",
                          |      "api": "http://anypoint.com/vocabs/api#"
                          |    },
                          |    "required": [
                          |      "descriptorVersion"
                          |    ],
                          |    "properties": {
                          |      "descriptorVersion": {
                          |        "const": "1.0.0"
                          |      },
                          |      "dependencies": {
                          |        "type": "array",
                          |        "items": {
                          |          "$ref": "#/definitions/ProjectDependency"
                          |        }
                          |      },
                          |      "instances": {
                          |        "type": "array",
                          |        "items": {
                          |          "$ref": "#/definitions/Gcl"
                          |        }
                          |      }
                          |    }
                          |  },
                          |  "else": {
                          |    "properties": {
                          |      "descriptorVersion": {
                          |        "const": "0.1.0"
                          |      },
                          |      "dependencies": {
                          |        "type": "array",
                          |        "items": {
                          |          "$ref": "#/definitions/LegacyProjectDependency"
                          |        }
                          |      }
                          |    }
                          |  },
                          |  "definitions": {
                          |    "LegacyProjectDependency": {
                          |      "oneOf": [
                          |        {
                          |          "$ref": "#/definitions/Gav"
                          |        }
                          |      ],
                          |      "properties": {
                          |        "scope": {
                          |          "type": "string"
                          |        }
                          |      }
                          |    },
                          |    "ProjectDependency": {
                          |      "oneOf": [
                          |        {
                          |          "$ref": "#/definitions/LegacyProjectDependency"
                          |        }
                          |      ],
                          |      "properties": {
                          |        "scope": {
                          |          "enum": [
                          |            "design",
                          |            "validation",
                          |            "design-extension"
                          |          ]
                          |        },
                          |        "provided": {
                          |          "type": "boolean"
                          |        }
                          |      }
                          |    },
                          |    "Metadata": {
                          |      "@context": {
                          |        "data": "http://a.ml/vocabularies/data#",
                          |        "branchId": "data:branchId",
                          |        "projectId": "data:projectId",
                          |        "commitId": "data:commitId"
                          |      },
                          |      "properties": {
                          |        "branchId": {
                          |          "type": "string"
                          |        },
                          |        "commitId": {
                          |          "type": "string"
                          |        },
                          |        "projectId": {
                          |          "type": "string"
                          |        }
                          |      }
                          |    },
                          |    "Gav": {
                          |      "@context": {
                          |        "catalog": "http://anypoint.com/vocabs/digital-repository#",
                          |        "groupId": "catalog:groupId",
                          |        "assetId": "catalog:assetId",
                          |        "version": "catalog:version"
                          |      },
                          |      "required": ["groupId", "assetId", "version"],
                          |      "properties": {
                          |        "groupId": {
                          |          "type": "string"
                          |        },
                          |        "assetId": {
                          |          "type": "string"
                          |        },
                          |        "version": {
                          |          "type": "string"
                          |        }
                          |      }
                          |    },
                          |    "Gcl": {
                          |      "@context": {
                          |        "data": "http://a.ml/vocabularies/data#",
                          |        "gcl": "data:gcl",
                          |        "definedBy": "data:definedBy"
                          |      },
                          |      "required": [
                          |        "gcl"
                          |      ],
                          |      "properties": {
                          |        "gcl": {
                          |          "type": "string"
                          |        },
                          |        "definedBy": {
                          |          "type": "string"
                          |        }
                          |      }
                          |    }
                          |  }
                          |}""".stripMargin
}
