package org.mulesoft.apb.project.client.scala.model

import amf.core.client.scala.vocabulary.Namespace.Data
import amf.core.internal.metamodel.Type.{Bool, Str}
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.metamodel.{Field, Type}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.{JsonLDElementModel, JsonLDEntityModel}
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.ProjectDependencyModel.{AssetId, GroupId, Version}
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.{Anypoint, Api, Catalog}

object ProjectDescriptorModel {
  val Main                  = Field(Str, Data + "main", doc("main"))
  val Name                  = Field(Str, Data + "name", doc("name"))
  val Classifier            = Field(Str, Data + "classifier", doc("classifier"))
  val ApiVersion            = Field(Str, Data + "apiVersion", doc("apiVersion"))
  val OrganizationId        = Field(Str, Anypoint + "organizationId", doc("organizationId"))
  val OriginalFormatVersion = Field(Str, Data + "originalFormatVersion", doc("originalFormatVersion"))
  val BackwardsCompatible   = Field(Bool, Data + "backwardsCompatible", doc("backwardsCompatible"))
  val PublishWithRefFiles   = Field(Bool, Data + "publishWithRefFiles", doc("publishWithRefFiles"))
  val Description           = Field(Str, Data + "description", doc("description"))
  val DescriptorVersion     = Field(Str, Data + "descriptorVersion", doc("descriptorVersion"))
  val Metadata              = Field(JsonLDElementModel, Data + "metadata", doc("metadata"))
  val Dependencies =
    Field(Type.Array(JsonLDElementModel), Catalog + "dependencies", doc("dependencies"))
  val Tags         = Field(Type.Array(Str), Data + "tags", doc("tags"))
  val ApiInstances = Field(Type.Array(JsonLDElementModel), Api + "instances", doc("instances"))
  val ProjectId    = Field(Str, Data + "projectId", doc("projectId"))

  val `type` = List(Data + "descriptor")

  val fields = List(
      Main,
      Name,
      Classifier,
      ApiVersion,
      OrganizationId,
      OriginalFormatVersion,
      BackwardsCompatible,
      PublishWithRefFiles,
      Description,
      DescriptorVersion,
      Metadata,
      GroupId,
      AssetId,
      Version,
      Tags,
      ProjectId,
      Dependencies,
      ApiInstances
  )
  private def doc(name: String) = ModelDoc(displayName = name)

  val entityModel: JsonLDEntityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}

object ProjectDescriptorModelIris {
  val Main: String                  = ProjectDescriptorModel.Main.value.iri()
  val Name: String                  = ProjectDescriptorModel.Name.value.iri()
  val Classifier: String            = ProjectDescriptorModel.Classifier.value.iri()
  val GroupId: String               = ProjectDependencyModel.GroupId.value.iri()
  val AssetId: String               = ProjectDependencyModel.AssetId.value.iri()
  val Version: String               = ProjectDependencyModel.Version.value.iri()
  val ApiVersion: String            = ProjectDescriptorModel.ApiVersion.value.iri()
  val OrganizationId: String        = ProjectDescriptorModel.OrganizationId.value.iri()
  val OriginalFormatVersion: String = ProjectDescriptorModel.OriginalFormatVersion.value.iri()
  val BackwardsCompatible: String   = ProjectDescriptorModel.BackwardsCompatible.value.iri()
  val PublishWithRefFiles: String   = ProjectDescriptorModel.PublishWithRefFiles.value.iri()
  val Description: String           = ProjectDescriptorModel.Description.value.iri()
  val DescriptorVersion: String     = ProjectDescriptorModel.DescriptorVersion.value.iri()

  val Metadata: String  = ProjectDescriptorModel.Metadata.value.iri()
  val BranchId: String  = MetadataModel.BranchId.value.iri()
  val CommitId: String  = MetadataModel.CommitId.value.iri()
  val ProjectId: String = MetadataModel.ProjectId.value.iri()

  val Dependencies: String = ProjectDescriptorModel.Dependencies.value.iri()
  val Tags: String         = ProjectDescriptorModel.Tags.value.iri()

  val ApiInstances: String = ProjectDescriptorModel.ApiInstances.value.iri()
  val GCL: String          = InstanceModel.GCL.value.iri()
  val DefinedBy: String    = InstanceModel.DefinedBy.value.iri()
}
