package org.mulesoft.apb.project.internal.ops

import amf.core.client.scala.model.domain.AmfObject
import amf.core.internal.metamodel.Obj
import amf.core.internal.parser.domain.{Annotations, Fields}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptorModel

object JsonLdObjectOps {

  def toObj[T <: AmfObject](element: T): JsonLDObject = {
    createObj(element, element.meta)
  }

  def toObj(fields: Fields, meta: Obj): JsonLDObject = {
    val objMeta = JsonLDEntityModel(meta.`type`, meta.fields, JsonPath.empty)
    JsonLDObject(fields, Annotations.empty, objMeta, JsonPath.empty)
  }

  def createObj(obj: AmfObject, objMeta: Obj): JsonLDObject = {
    val meta = JsonLDEntityModel(objMeta.`type`, objMeta.fields, JsonPath.empty)
    JsonLDObject(obj.fields, Annotations.empty, meta, JsonPath.empty)
  }
}
