package org.mulesoft.apb.project.internal.instances

import scala.collection.immutable

case class ResourceVersion private (version: String)

object ResourceVersion {
  val gatewayV1Alpha1: ResourceVersion = ResourceVersion("gateway.mulesoft.com/v1alpha1")
  val gatewayV1Beta1: ResourceVersion  = ResourceVersion("gateway.mulesoft.com/v1beta1")
  val networkV1Alpha1: ResourceVersion = ResourceVersion("network.mulesoft.com/v1alpha1")
  val default: ResourceVersion         = gatewayV1Alpha1

  val ValidVersions: immutable.Seq[ResourceVersion] = List(gatewayV1Alpha1, gatewayV1Beta1, networkV1Alpha1)
}
