package org.mulesoft.apb.project.client.platform.model

import amf.apicontract.internal.convert.ApiClientConverters.{ClientList, ClientOption}
import org.mulesoft.apb.project.client.scala.model.{ProjectDescriptor => InternalProjectDescriptor}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.JSExportAll

@JSExportAll
case class ProjectDescriptor private[apb] (override private[apb] val _internal: InternalProjectDescriptor)
    extends JsonLDObjectWrapper(_internal) {

  def this(main: String) = this(InternalProjectDescriptor(main))

  val main: String                                = _internal.main
  val name: String                                = _internal.name
  val gav: Gav                                    = _internal.gav
  val classifier: ClientOption[String]            = _internal.classifier.asClient
  val tags: ClientList[String]                    = _internal.tags.asClient
  val apiVersion: ClientOption[String]            = _internal.apiVersion.asClient
  val organizationId: ClientOption[String]        = _internal.organizationId.asClient
  val originalFormatVersion: ClientOption[String] = _internal.originalFormatVersion.asClient
  val metadata: ClientOption[Metadata]            = _internal.metadata.asClient
  val backwardsCompatible: ClientOption[Boolean]  = _internal.backwardsCompatible.asClient
  val publishWithRefFiles: ClientOption[Boolean]  = _internal.publishWithRefFiles.asClient
  val description: ClientOption[String]           = _internal.description.asClient
  val projectId: ClientOption[String]             = _internal.projectId.asClient
  val dependencies: ClientList[ProjectDependency] = _internal.dependencies.asClient
  val descriptorVersion: String                   = _internal.descriptorVersion
  val instances: ClientList[Instance]             = _internal.instances.asClient
  val status: ClientOption[String]                = _internal.status.asClient
  val createdAt: ClientOption[String]             = _internal.createdAt.asClient
  val createdBy: ClientOption[String]             = _internal.createdBy.asClient
  val customFields: ClientList[String]            = _internal.customFields.asClient
  val keyValueTags: ClientList[String]            = _internal.keyValueTags.asClient
  val tenantId: ClientOption[String]              = _internal.tenantId.asClient
  val categories: ClientList[String]              = _internal.categories.asClient
  val `type`: ClientOption[String]                = _internal.`type`.asClient
  val majorVersionComponent: ClientOption[Int]    = _internal.majorVersionComponent.asClient
  val minorVersionComponent: ClientOption[Int]    = _internal.minorVersionComponent.asClient
  val patchVersionComponent: ClientOption[Int]    = _internal.patchVersionComponent.asClient

  def isLegacyDescriptor: Boolean = _internal.isLegacyDescriptor

  def withMain(main: String): ProjectDescriptor = _internal.withMain(main)

  def withDependency(dependency: ProjectDependency): ProjectDescriptor = _internal.withDependency(dependency)

  def withInstance(instance: Instance): ProjectDescriptor = _internal.withInstance(instance)

  def withInstances(instances: ClientList[Instance]): ProjectDescriptor = _internal.withInstances(instances.asInternal)

  def withName(name: String): ProjectDescriptor = _internal.withName(name)

  def withDescriptorVersion(version: String): ProjectDescriptor = _internal.withDescriptorVersion(version)

  def withGav(gav: Gav): ProjectDescriptor = _internal.withGav(gav)

  def withClassifier(classifier: String): ProjectDescriptor = _internal.withClassifier(classifier)

  def withTags(tags: Seq[String]): ProjectDescriptor = _internal.withTags(tags)

  def withTag(tag: String): ProjectDescriptor = _internal.withTag(tag)

  def withApiVersion(apiVersion: String): ProjectDescriptor = _internal.withApiVersion(apiVersion)

  def withOrganizationId(organizationId: String): ProjectDescriptor = _internal.withOrganizationId(organizationId)

  def withOriginalFormatVersion(originalFormatVersion: String): ProjectDescriptor =
    _internal.withOriginalFormatVersion(originalFormatVersion)

  def withMetadata(metadata: Metadata): ProjectDescriptor = _internal.withMetadata(metadata)

  def withBackwardsCompatible(value: Boolean): ProjectDescriptor = _internal.withBackwardsCompatible(value)

  def withPublishWithRefFiles(value: Boolean): ProjectDescriptor = _internal.withPublishWithRefFiles(value)

  def withDescription(description: String): ProjectDescriptor = _internal.withDescription(description)

  def withProjectId(projectId: String): ProjectDescriptor = _internal.withProjectId(projectId)

  def withStatus(status: String): ProjectDescriptor = _internal.withStatus(status)

  def withCreatedAt(createdAt: String): ProjectDescriptor = _internal.withCreatedAt(createdAt)

  def withUpdatedAt(updatedAt: String): ProjectDescriptor = _internal.withUpdatedAt(updatedAt)

  def withCreatedBy(createdBy: String): ProjectDescriptor = _internal.withCreatedBy(createdBy)

  def withTenantId(tenantId: String): ProjectDescriptor = _internal.withTenantId(tenantId)

  def withCategories(categories: Seq[String]): ProjectDescriptor = _internal.withCategories(categories)

  def withFields(fields: Seq[String]): ProjectDescriptor = _internal.withFields(fields)

  def withKeyValueTags(keyValueTags: Seq[String]): ProjectDescriptor = _internal.withKeyValueTags(keyValueTags)

  def withType(`type`: String): ProjectDescriptor = _internal.withType(`type`)

  def withMajorVersionComponent(version: Int): ProjectDescriptor = _internal.withMajorVersionComponent(version)

  def withMinorVersionComponent(version: Int): ProjectDescriptor = _internal.withMinorVersionComponent(version)

  def withPatchVersionComponent(version: Int): ProjectDescriptor = _internal.withPatchVersionComponent(version)
}
