package org.mulesoft.apb.project.client.scala.instances

import amf.core.client.scala.model.domain.AmfArray
import amf.shapes.client.scala.model.document.JsonLDInstanceDocument
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.document.metamodel.JsonLDInstanceDocumentModel.Encodes
import org.mulesoft.apb.project.client.scala.instances.APIInstanceModel._
import org.mulesoft.apb.project.client.scala.instances.inline.{InlineEnvironment, InlinePolicyBindings, InlineService}
import org.mulesoft.apb.project.client.scala.model.DynamicObject.toJsonLDObject
import org.mulesoft.apb.project.client.scala.model.management.SchemaIris.{
  CONFIG,
  DESTINATION_REF,
  ENVIRONMENT,
  ENVIRONMENT_TARGET_REF,
  NAME,
  POLICY_REF,
  SPEC
}
import org.mulesoft.apb.project.client.scala.model.management.{
  APIInstance,
  Environment,
  EnvironmentBinding,
  PolicyBinding,
  Service
}
import org.mulesoft.apb.project.internal.instances.{
  EnvironmentIndex,
  ErrorAPIInstance,
  PolicyBindingIndex,
  ResourceCatalog
}

import scala.language.implicitConversions

class APIInstanceBuilder(instances: List[JsonLDInstanceDocument]) {

  private val catalog              = ResourceCatalog(instances)
  private val policyBindingInliner = InlinePolicyBindings(catalog.policiesIndex)
  private val serviceInliner       = InlineService(catalog.policiesIndex)
  private val environmentInliner   = InlineEnvironment(catalog.environmentIndex)
  // TODO: should we return a list of APIInstances here so an user can build instances independently????
  def build(): Seq[APIInstance] = {
    inlineServicesIntoPolicyBindings()
    val instances = catalog.getApiInstances.map { apiInstance =>
      inlinePolicyBindings(apiInstance)
      inlineEnvironments(apiInstance)
      apiInstance
    }
    instances
  }

  private def inlineServicesIntoPolicyBindings(): Unit = {
    catalog.getServices.foreach(inlineServices)
  }

  private def inlineServices(service: Service): Unit            = serviceInliner.inlineInto(service)
  private def inlinePolicyBindings(instance: APIInstance): Unit = policyBindingInliner.inlineInto(instance)
  private def inlineEnvironments(instance: APIInstance): Unit   = environmentInliner.inlineInto(instance)
}
