package org.mulesoft.apb.project.internal.idadoption

import amf.aml.internal.metamodel.document.DialectModel
import amf.core.client.scala.model.domain.{AmfElement, AmfObject}
import amf.core.internal.adoption.{DefaultIdMaker, IdAdopter, IdMaker}
import amf.core.internal.parser.domain.FieldEntry
import amf.shapes.internal.document.metamodel.JsonLDInstanceDocumentModel

class APBIdAdopter(initialElem: AmfObject, initialId: String)
    extends IdAdopter(initialElem, initialId, new APBIdMaker()) {

  override def adoptFromRoot(): Unit = {
    super.adoptFromRoot()
    initialElem.withId(initialId + "/document")
  }

}

class APBIdMaker extends DefaultIdMaker {

  override def makeArrayElementId(parent: String, index: Int, element: AmfElement): String = {
    super.makeArrayElementId(parent, index, element).stripSuffix("/")
  }

  override def makeId(parent: AmfObject, field: FieldEntry, isRoot: Boolean): String = {
    if (field.field == JsonLDInstanceDocumentModel.Encodes || field.field == DialectModel.Encodes)
      parent.id.stripSuffix("/")
    else super.makeId(parent, field, isRoot)
  }
}
