package org.mulesoft.apb.project.client.platform.model

import amf.shapes.client.platform.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.{JsonLDObjectWrapper => InternalJsonLDObjectWrapper}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

abstract class JsonLDObjectWrapper(private[apb] val _internal: InternalJsonLDObjectWrapper) {

  def withDynamicProperty(key: String, value: String): JsonLDObjectWrapper =
    _internal.withDynamicProperty(key, value).asInstanceOf[InternalJsonLDObjectWrapper]

  def withDynamicProperty(key: String, value: Int): JsonLDObjectWrapper =
    _internal.withDynamicProperty(key, value).asInstanceOf[InternalJsonLDObjectWrapper]

  def withDynamicProperty(key: String, value: Boolean): JsonLDObjectWrapper =
    _internal.withDynamicProperty(key, value).asInstanceOf[InternalJsonLDObjectWrapper]

  def withDynamicProperty(key: String, value: Float): JsonLDObjectWrapper =
    _internal.withDynamicProperty(key, value).asInstanceOf[InternalJsonLDObjectWrapper]

  def withDynamicProperty(key: String, value: JsonLDObject): JsonLDObjectWrapper =
    _internal.withDynamicProperty(key, value).asInstanceOf[InternalJsonLDObjectWrapper]

}
