package org.mulesoft.apb.project.client.platform.model

import org.mulesoft.apb.project.client.scala.model.DependencyScope

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}
import org.mulesoft.apb.project.client.scala.model.{ProjectDependency => InternalProjectDependency}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

@JSExportAll
case class ProjectDependency private[apb] (override private[apb] val _internal: InternalProjectDependency)
    extends JsonLDObjectWrapper(_internal) {

  @JSExportTopLevel("ProjectDependency")
  def this(gav: Gav) = this(InternalProjectDependency(gav._internal))

  val gav: Gav                  = GavMatcher.asClient(_internal.gav)
  val scope: DependencyScope    = _internal.scope
  val hasExplicitScope: Boolean = _internal.hasExplicitScope
  val shouldBeProvided: Boolean = _internal.shouldBeProvided

  val absolutePath: String = _internal.absolutePath

  def withScope(scope: DependencyScope): ProjectDependency = _internal.withScope(scope)

  def withProvided(provided: Boolean): ProjectDependency = _internal.withProvided(provided)
}
