package org.mulesoft.apb.project.client.platform.model.management

import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.management.{APIInstance => InternalAPIInstance}
import org.mulesoft.apb.project.internal.convert.ManagementClientConverters._
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}
@JSExportAll
class APIInstance(override private[apb] val internal: InternalAPIInstance)
    extends DynamicObject(internal)
    with HasName
    with HasAnnotations
    with HasLabels {

  @JSExportTopLevel("APIInstance")
  def this(name: String, address: String) = this(InternalAPIInstance(name, address))

  def address: String = internal.address

  def withAddress(address: String): this.type = {
    internal.withAddress(address)
    this
  }

  def policyBindings: ClientList[PolicyBinding] = internal.policyBindings.asClient

  def withPolicyBinding(): PolicyBinding = internal.withPolicyBinding()

  def services: ClientList[Service] = internal.services.asClient

  def withService(name: String, address: String): Service = internal.withService(name, address)

  def environment: Environment = internal.environment

  def withEnvironment(name: String): Environment = internal.withEnvironment(name)
}
