package org.mulesoft.apb.project.client.scala.model

import scala.scalajs.js.annotation.{JSExport, JSExportAll, JSExportTopLevel}

@JSExportAll
sealed case class DependencyScope(scope: String)

@JSExportAll
@JSExportTopLevel("DependencyScope")
object DependencyScope {

  @JSExport("apply")
  def apply(scope: String): DependencyScope = scope match {
    case ValidationScope.scope => ValidationScope
    case ExtensionScope.scope  => ExtensionScope
    case ManagementScope.scope => ManagementScope
    case _                     => DesignScope
  }

  val Design: DependencyScope     = DesignScope
  val Validation: DependencyScope = ValidationScope
  val Extension: DependencyScope  = ExtensionScope
  val Management: DependencyScope = ManagementScope
}

@JSExportAll
@JSExportTopLevel("DesignScope")
object DesignScope extends DependencyScope("design")

@JSExportAll
@JSExportTopLevel("ValidationScope")
object ValidationScope extends DependencyScope("validation")

@JSExportAll
@JSExportTopLevel("ExtensionScope")
object ExtensionScope extends DependencyScope("design-extension")

@JSExportAll
@JSExportTopLevel("ManagementScope")
object ManagementScope extends DependencyScope("management")
