package org.mulesoft.apb.project.client.scala.model.management

import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.management.SchemaIris.{NAME, RichString}

class NamedRef(private[apb] val internal: JsonLDObject) extends DynamicObject {
  def name: String                      = getScalar[String](NAME)
  def withName(name: String): this.type = withProperty(NAME, name)

}

object NamedRef {
  def apply(name: String, propertyIri: String): NamedRef = {
    val model = propertyIri.toModel
    val init  = JsonLDObject.empty(model, model.path)
    new NamedRef(init)
      .withName(name)
  }
}
