package org.mulesoft.apb.project.client.scala.transformation

import amf.core.client.scala.transform.{TransformationPipeline, TransformationStep}
import org.mulesoft.apb.project.client.scala.dependency.DesignDependency

abstract class APBBasePipeline(companionLibs: Seq[DesignDependency]) extends TransformationPipeline {

  private val customAPBSteps: Seq[TransformationStep] = Seq(new CompanionLibCheckTransformationStage(companionLibs))
  protected val basePipeline: TransformationPipeline

  override lazy val name: String              = basePipeline.name
  override def steps: Seq[TransformationStep] = customAPBSteps ++ basePipeline.steps

}
