package org.mulesoft.apb.project.internal

import amf.core.client.common.validation.{ProfileName, ProfileNames}
import amf.core.client.scala.model.document.BaseUnit
import amf.core.client.scala.model.domain.DomainElement
import amf.core.client.scala.{AMFParseResult, AMFResult}
import amf.core.client.scala.validation.{AMFValidationReport, AMFValidationResult}
import amf.core.internal.remote.Spec
import amf.core.internal.remote.Spec.AMF

case class BuildResult[T](result: T, report: AMFValidationReport)

object BuildResult {
  def apply(result: AMFResult): BuildResult[BaseUnit] = {
    val report = AMFValidationReport(result.baseUnit.id, profile(result.baseUnit), result.results)
    BuildResult(result.baseUnit, report)
  }

  def apply(unit: BaseUnit): BuildResult[BaseUnit] = {
    val report = AMFValidationReport.empty(unit.id, profile(unit))
    BuildResult(unit, report)
  }

  def apply[T <: DomainElement](element: T): BuildResult[T] = {
    val report = AMFValidationReport.empty(element.id, ProfileNames.AMF)
    BuildResult(element, report)
  }

  def apply[T](element: T, id: String, errors: Seq[AMFValidationResult]): BuildResult[T] = {
    val report = AMFValidationReport(id, ProfileNames.AMF, errors)
    BuildResult(element, report)
  }

  private def profile(unit: BaseUnit) = ProfileName(spec(unit).id)
  private def spec(unit: BaseUnit)    = unit.sourceSpec.getOrElse(AMF)
}
