package org.mulesoft.apb.project.internal.descriptor

import amf.core.client.scala.vocabulary.{Namespace, NamespaceAliases}

object ApiProjectNamespaces {

  val Core       = Namespace("http://a.ml/vocabularies/core#")
  val Anypoint   = Namespace("http://anypoint.com/vocabs/anypoint#")
  val Catalog    = Namespace("http://anypoint.com/vocabs/digital-repository#")
  val Api        = Namespace("http://anypoint.com/vocabs/api#")
  val Contract   = Namespace("http://a.ml/vocabularies/apiContract#")
  val Management = Namespace("http://anypoint.com/vocabs/management#")

  val aliases = NamespaceAliases.withCustomAliases(
      Map(
          "core"       -> Core,
          "anypoint"   -> Anypoint,
          "catalog"    -> Catalog,
          "api"        -> Api,
          "contract"   -> Contract,
          "management" -> Management
      )
  )
}
