package org.mulesoft.apb.project.internal.engine

import org.mulesoft.apb.project.client.scala.dependency.{
  Dependency,
  DesignDependency,
  ExtensionDependency,
  ProfileDependency
}

import scala.collection.mutable.ListBuffer

object PartitionedDependencies {

  def apply(deps: Seq[Dependency]): (List[DesignDependency], List[ProfileDependency], List[ExtensionDependency]) = {
    val design: ListBuffer[DesignDependency]       = ListBuffer.empty
    val profile: ListBuffer[ProfileDependency]     = ListBuffer.empty
    val extension: ListBuffer[ExtensionDependency] = ListBuffer.empty
    deps.foreach {
      case d: DesignDependency    => design += d
      case p: ProfileDependency   => profile += p
      case e: ExtensionDependency => extension += e
      case _                      => // ignore
    }
    (design.toList, profile.toList, extension.toList)
  }
}
