package org.mulesoft.apb.project.internal.instances

case class ResourceKind private (kind: String)

object ResourceKind {
  val ApiInstance: ResourceKind        = ResourceKind("ApiInstance")
  val EnvironmentBinding: ResourceKind = ResourceKind("EnvironmentBinding")
  val Environment: ResourceKind        = ResourceKind("Environment")
  val Extension: ResourceKind          = ResourceKind("Extension")
  val PolicyBinding: ResourceKind      = ResourceKind("PolicyBinding")
  val Service: ResourceKind            = ResourceKind("Service")
  val Other: ResourceKind              = ResourceKind("Other")
}
