package org.mulesoft.apb.project.internal.metamodel

import amf.apicontract.internal.metamodel.domain.api.BaseApiModel
import amf.core.client.scala.model.domain.AmfObject
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Type.{DateTime, Str}
import amf.core.internal.metamodel.document.BaseUnitModel
import amf.core.internal.metamodel.domain.{DomainElementModel, ModelDoc, ModelVocabularies}
import amf.core.internal.metamodel.{Field, Type}
import org.mulesoft.apb.project.client.scala.model.ProjectDependencyModel.{AssetId, GroupId, Version}
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptorModel._
import org.mulesoft.apb.project.client.scala.model.ProjectInfo
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.{Anypoint, Api, Catalog, Core}

object ProjectInfoModel extends DomainElementModel {
  override def modelInstance: AmfObject = ProjectInfo()

  val Contract: Field = Field(
      BaseUnitModel,
      Api + "contract",
      ModelDoc(
          ModelVocabularies.AmlDoc,
          "apiContract",
          "Documentation spec for this particular API project"
      )
  )

  val Instances: Field = Field(
      Type.Array(DomainElementModel),
      Api + "instance",
      ModelDoc(
          ModelVocabularies.AmlDoc,
          "apiInstances",
          "Instances related to this API project"
      )
  )

  override def fields: List[Field] =
    List(
        Name,
        Contract,
        Instances,
        Classifier,
        GroupId,
        AssetId,
        Version,
        OrganizationId,
        Dependencies,
        CustomFields,
        Categories,
        Tags,
        KeyValueTags,
        CreatedBy,
        CreatedAt,
        Status,
        TenantId,
        MajorVersionComponent,
        MinorVersionComponent,
        PatchVersionComponent,
        UpdatedAt,
        TypeField
    ) ++ DomainElementModel.fields

  override val `type`: List[ValueType] = List(Api + "Project") ++ DomainElementModel.`type`
}
