package org.mulesoft.apb.project.internal.parser

import amf.aml.internal.parse.plugin.AMLDialectParsingPlugin
import amf.aml.internal.validate.DialectEnumValidationPlugin
import amf.core.client.scala.model.document.BaseUnit
import amf.core.client.scala.parse.document.{ParsedDocument, ParserContext, UnspecifiedReference}
import amf.core.client.scala.validation.{AMFValidationReport, AMFValidationResult}
import amf.core.client.scala.{AMFGraphConfiguration, AMFParseResult}
import amf.core.internal.parser.{ParseConfig, Root}
import amf.core.internal.plugins.syntax.SyamlSyntaxParsePlugin
import amf.core.internal.remote.Mimes.`application/yaml`

object SyncDialectParser {

  def parse(content: String): AMFParseResult = {
    val ctx    = createParserContext(AMFGraphConfiguration.predefined())
    val syntax = parseSyntax(content, ctx)
    val unit   = parseDomain(syntax, ctx)
    new AMFParseResult(unit, ctx.eh.getResults)
  }

  private def parseDomain(doc: ParsedDocument, ctx: ParserContext) =
    new AMLDialectParsingPlugin().parse(createRoot(doc), ctx)

  private def createRoot(doc: ParsedDocument) = Root(
      doc,
      "",
      `application/yaml`,
      Seq.empty,
      UnspecifiedReference,
      ""
  )

  private def parseSyntax(content: String, ctx: ParserContext) =
    SyamlSyntaxParsePlugin.parse(content, `application/yaml`, ctx)

  private def createParserContext(config: AMFGraphConfiguration) = ParserContext(
      config = ParseConfig(config)
  )
}
