package org.mulesoft.apb.project.client.scala.model

import amf.core.client.scala.model.document.BaseUnit
import amf.core.client.scala.model.domain.DomainElement
import amf.core.internal.metamodel.Obj
import amf.core.internal.parser.domain.{Annotations, Fields}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.internal.metamodel.ProjectInfoModel
import org.mulesoft.apb.project.internal.metamodel.ProjectInfoModel.{Contract, Instances}

class ProjectInfo(override val fields: Fields, override val annotations: Annotations)
    extends DomainElement
    with ProjectBase {
  override def meta: Obj = ProjectInfoModel

  def apiContract(): BaseUnit         = fields.field(Contract)
  def instances(): List[JsonLDObject] = fields.field(Instances)
  override def componentId: String    = ""
}

object ProjectInfo {
  def apply() = new ProjectInfo(Fields(), Annotations())
}
