package org.mulesoft.apb.project.client.scala.model.management

import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.management.SchemaIris.{RichString, TARGET_REF, NAMED_REF_KIND}

case class NamedRefWithKind(private[apb] override val internal: JsonLDObject) extends NamedRef(internal) {
  def kind: String                      = getScalar[String](NAMED_REF_KIND)
  def withKind(kind: String): this.type = withProperty(NAMED_REF_KIND, kind)
}

object NamedRefWithKind {
  def apply(name: String, kind: String, propertyIri: String): NamedRefWithKind = {
    val model = propertyIri.toModel
    val init  = JsonLDObject.empty(model, model.path)
    NamedRefWithKind(init)
      .withKind(kind)
      .withName(name)
  }
}
