package org.mulesoft.apb.project.client.scala.model

import amf.core.client.scala.vocabulary.Namespace.Data
import amf.core.internal.metamodel.Type.{Bool, DateTime, Str}
import amf.core.internal.metamodel.domain.{ModelDoc, ModelVocabularies}
import amf.core.internal.metamodel.{Field, Obj, Type}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.{JsonLDElementModel, JsonLDEntityModel}
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.ProjectDependencyModel.{AssetId, GroupId, Version}
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptorModel.doc
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.{Anypoint, Api, Catalog, Core}

object ProjectDescriptorModel {
  val Main                  = Field(Str, Data + "main", doc("main"))
  val Name                  = Field(Str, Core + "name", doc("name"))
  val Classifier            = Field(Str, Catalog + "classifier", doc("classifier"))
  val ApiVersion            = Field(Str, Data + "apiVersion", doc("apiVersion"))
  val OrganizationId        = Field(Str, Anypoint + "organizationId", doc("organizationId"))
  val OriginalFormatVersion = Field(Str, Data + "originalFormatVersion", doc("originalFormatVersion"))
  val BackwardsCompatible   = Field(Bool, Data + "backwardsCompatible", doc("backwardsCompatible"))
  val PublishWithRefFiles   = Field(Bool, Data + "publishWithRefFiles", doc("publishWithRefFiles"))
  val Description           = Field(Str, Data + "description", doc("description"))
  val DescriptorVersion     = Field(Str, Data + "descriptorVersion", doc("descriptorVersion"))
  val Metadata              = Field(JsonLDElementModel, Data + "metadata", doc("metadata"))
  val Dependencies =
    Field(Type.Array(JsonLDElementModel), Catalog + "dependency", doc("dependencies"))
  val Tags         = Field(Type.Array(Str), Catalog + "tags", doc("tags"))
  val ApiInstances = Field(Type.Array(JsonLDElementModel), Api + "instance", doc("instances"))
  val ProjectId    = Field(Str, Data + "projectId", doc("projectId"))

  val KeyValueTags: Field = Field(
      Type.Array(Str),
      Catalog + "keyValueTags",
      doc("keyValueTags")
  )

  val CreatedBy: Field = Field(
      Str,
      Anypoint + "userId",
      doc("createdBy")
  )

  val CreatedAt: Field = Field(
      Str,
      Core + "dateCreated",
      doc("createdAt")
  )

  val UpdatedAt: Field = Field(
      Str,
      Core + "dateModified",
      doc("updatedAt")
  )

  val Status: Field = Field(
      Str,
      Catalog + "status",
      doc("status")
  )

  val TenantId: Field = Field(
      Str,
      Anypoint + "tenantId",
      doc("tenantId")
  )

  val MajorVersionComponent: Field = Field(
      Type.Int,
      Catalog + "majorVersionComponent",
      doc("majorVersionComponent")
  )

  val MinorVersionComponent: Field = Field(
      Type.Int,
      Catalog + "minorVersionComponent",
      doc("minorVersionComponent")
  )

  val PatchVersionComponent: Field = Field(
      Type.Int,
      Catalog + "patchVersionComponent",
      doc("patchVersionComponent")
  )

  val CustomFields: Field = Field(
      Type.Array(Str),
      Catalog + "customFields",
      doc("fields")
  )

  val Categories: Field = Field(
      Type.Array(Str),
      Catalog + "categories",
      doc("categories")
  )

  val TypeField: Field = Field(
      Str,
      Api + "type",
      doc("type")
  )

  val `type` = List(Data + "Descriptor")

  val fields = List(
      Main,
      Name,
      Classifier,
      ApiVersion,
      OrganizationId,
      OriginalFormatVersion,
      BackwardsCompatible,
      PublishWithRefFiles,
      Description,
      DescriptorVersion,
      Metadata,
      GroupId,
      AssetId,
      Version,
      Tags,
      ProjectId,
      Dependencies,
      ApiInstances,
      KeyValueTags,
      CreatedBy,
      CreatedAt,
      UpdatedAt,
      Status,
      TenantId,
      MajorVersionComponent,
      MinorVersionComponent,
      PatchVersionComponent,
      CustomFields,
      Categories,
      TypeField
  )
  private def doc(name: String) = ModelDoc(displayName = name)

  val entityModel: JsonLDEntityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}

object ProjectDescriptorModelIris {
  val Main: String                  = ProjectDescriptorModel.Main.value.iri()
  val Name: String                  = ProjectDescriptorModel.Name.value.iri()
  val Classifier: String            = ProjectDescriptorModel.Classifier.value.iri()
  val GroupId: String               = ProjectDependencyModel.GroupId.value.iri()
  val AssetId: String               = ProjectDependencyModel.AssetId.value.iri()
  val Version: String               = ProjectDependencyModel.Version.value.iri()
  val ApiVersion: String            = ProjectDescriptorModel.ApiVersion.value.iri()
  val OrganizationId: String        = ProjectDescriptorModel.OrganizationId.value.iri()
  val OriginalFormatVersion: String = ProjectDescriptorModel.OriginalFormatVersion.value.iri()
  val BackwardsCompatible: String   = ProjectDescriptorModel.BackwardsCompatible.value.iri()
  val PublishWithRefFiles: String   = ProjectDescriptorModel.PublishWithRefFiles.value.iri()
  val Description: String           = ProjectDescriptorModel.Description.value.iri()
  val DescriptorVersion: String     = ProjectDescriptorModel.DescriptorVersion.value.iri()

  val Metadata: String  = ProjectDescriptorModel.Metadata.value.iri()
  val BranchId: String  = MetadataModel.BranchId.value.iri()
  val CommitId: String  = MetadataModel.CommitId.value.iri()
  val ProjectId: String = MetadataModel.ProjectId.value.iri()

  val Dependencies: String = ProjectDescriptorModel.Dependencies.value.iri()
  val Tags: String         = ProjectDescriptorModel.Tags.value.iri()

  val ApiInstances: String = ProjectDescriptorModel.ApiInstances.value.iri()
  val GCL: String          = InstanceModel.GCL.value.iri()
  val DefinedBy: String    = InstanceModel.DefinedBy.value.iri()
}
