package org.mulesoft.apb.project.client.scala.model.management

import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Field
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath

object SchemaIris {
  // namespaces
  val CORE       = "http://a.ml/vocabularies/core"
  val MANAGEMENT = "http://anypoint.com/vocabs/management"

  // instance & policy bindings
  val SPEC                   = s"$CORE#spec"
  val METADATA               = s"$CORE#metadata"
  val POLICIES               = s"$MANAGEMENT#policies"
  val INSTANCE_ADDRESS       = s"$CORE#address"
  val SERVICE                = s"$CORE#service"
  val POLICY_REF             = s"$CORE#policyRef"
  val TARGET_REF             = s"$CORE#targetRef"
  val CONFIG                 = s"$CORE#config"
  val POLICY_BINDING_RULES   = s"$CORE#rules"
  val ORDER                  = s"$CORE#order"
  val NAME                   = s"$CORE#name"
  val NAMESPACE              = s"$CORE#namespace"
  val LABELS                 = s"$CORE#labels"
  val ANNOTATIONS            = s"$CORE#annotations"
  val ENVIRONMENT_KIND       = s"$CORE#environmentKind"
  val ENVIRONMENT            = s"$CORE#environment"
  val ADDRESS                = s"$CORE#address"
  val ROUTES                 = s"$CORE#routes"
  val RULES                  = s"$CORE#rules"
  val DESTINATION_PATH       = s"$CORE#destinationPath"
  val DESTINATION_REF        = s"$CORE#destinationRef"
  val PATH                   = s"$CORE#path"
  val ENVIRONMENT_TARGET_REF = s"$CORE#targetEnvironmentRef"

  // policies
  val NAMED_REF_KIND = s"$CORE#kind"
  val METHOD         = s"$CORE#method"
  val HOST           = s"$CORE#host"
  val HEADERS        = s"$CORE#headers"

  // labels
  val API_INSTANCE_ID_LABEL    = s"$CORE#mulesoft.com/apiinstance-id"
  val API_INSTANCE_LABEL_LABEL = s"$CORE#mulesoft.com/apiinstance-label"

  implicit class RichString(str: String) {
    def toJsonPath: JsonPath = {
      val idx = str.indexOf("#")
      val segments = str
        .substring(idx + 1) // remove namespace
        .split("/")
        .toList
      JsonPath(segments)
    }

    def toStrField: Field = Field(amf.core.internal.metamodel.Type.Str, toValueType)

    def toObjField: Field = Field(amf.core.internal.metamodel.Type.ObjType, toValueType)

    def toValueType: ValueType = ValueType(str)

    def toModel: JsonLDEntityModel = {
      val path  = str.toJsonPath
      val type_ = str.toValueType
      JsonLDEntityModel(List(type_), Nil, path)
    }

  }
}

object Constants {
  def apiVersion: String             = "gateway.mulesoft.com/v1alpha1"
  def apiInstanceKind: String        = "ApiInstance"
  def policyBindingKind: String      = "PolicyBinding"
  def serviceKind: String            = "Service"
  def environmentKind: String        = "Environment"
  def environmentBindingKind: String = "EnvironmentBinding"
}
