package org.mulesoft.apb.project.client.scala.model

trait GavAware {
  def gav: Gav
}

object Gav {
  def unapply(gav: String): Option[Gav] = gav.split("/") match {
    case Array(group, asset, version) => Some(Gav(group, asset, version))
    case _                            => None
  }
}

case class Gav(groupId: String, assetId: String, version: String) {
  val path: String = s"$groupId/$assetId/$version/"

  def equalsTo(groupId: String, assetId: String, version: String): Boolean =
    this.groupId == groupId && this.assetId == assetId && this.version == version

  def nonEmpty: Boolean = this.groupId.nonEmpty || this.assetId.nonEmpty || this.version.nonEmpty
}
