package org.mulesoft.apb.project.internal.convert

import amf.apicontract.internal.convert.ApiBaseClientConverter
import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.convert.{BidirectionalMatcher, ClientInternalMatcher, InternalClientMatcher}
import org.mulesoft.apb.project.client.platform.dependency.{
  DesignDependency => ClientDesignDependency,
  ExtensionDependency => ClientExtensionDependency,
  ParsedDependency => ClientParsedDependency,
  ProfileDependency => ClientProfileDependency
}
import org.mulesoft.apb.project.client.platform.descriptor.{DescriptorParseResult => ClientDescriptorParseResult}
import org.mulesoft.apb.project.client.platform.environment.{DependencyFetcher => ClientDependencyFetcher}
import org.mulesoft.apb.project.client.platform.model.{
  Gav => ClientGav,
  Instance => ClientApiInstance,
  Metadata => ClientMetadataElement,
  ProjectDependency => ClientProjectDependency,
  ProjectDescriptor => ClientProjectDescriptor,
  JsonLDObjectWrapper => ClientJsonLDObjectWrapper
}
import org.mulesoft.apb.project.client.platform.{ProjectConfiguration => ClientProjectConfiguration}
import org.mulesoft.apb.project.client.scala.ProjectConfiguration
import org.mulesoft.apb.project.client.scala.dependency.{
  DesignDependency,
  ExtensionDependency,
  ParsedDependency,
  ProfileDependency
}
import org.mulesoft.apb.project.client.scala.descriptor.DescriptorParseResult
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.model.{
  Gav,
  Instance,
  JsonLDObjectWrapper,
  Metadata,
  ProjectDependency,
  ProjectDescriptor
}

import scala.concurrent.{ExecutionContext, Future}

trait APBProjectConverters extends ApiBaseClientConverter {
  implicit class FutureListConverter[Internal, Client](from: Future[Seq[Internal]])(implicit
      m: InternalClientMatcher[Internal, Client],
      executionContext: ExecutionContext
  ) {
    def asClient: ClientFuture[ClientList[Client]] = {
      asClientFuture(from.map(s => asClientList(s, m)))
    }
  }

  implicit object ProjectConfigurationClientConverter
      extends InternalClientMatcher[ProjectConfiguration, ClientProjectConfiguration] {
    override def asClient(from: ProjectConfiguration): ClientProjectConfiguration =
      new ClientProjectConfiguration(from)
  }

  implicit object DependencyFetcherConverter extends ClientInternalMatcher[ClientDependencyFetcher, DependencyFetcher] {
    override def asInternal(from: ClientDependencyFetcher): DependencyFetcher = new DependencyFetcher {
      override def accepts(groupId: String, assetId: String, version: String): Boolean =
        from.accepts(groupId, assetId, version)

      override def fetch(groupId: String, assetId: String, version: String): ResourceLoader = {
        ResourceLoaderMatcher.asInternal(from.fetch(groupId, assetId, version))(ExecutionContext.Implicits.global)
      }
    }
  }

  implicit object ParsedDependencyConverter extends InternalClientMatcher[ParsedDependency, ClientParsedDependency] {
    override def asClient(from: ParsedDependency): ClientParsedDependency = from match {
      case d: DesignDependency    => ClientDesignDependency(d)
      case e: ExtensionDependency => ClientExtensionDependency(e)
      case p: ProfileDependency   => ClientProfileDependency(p)
    }
  }

  implicit object DesignDependencyConverter extends BidirectionalMatcher[DesignDependency, ClientDesignDependency] {
    override def asClient(from: DesignDependency): ClientDesignDependency   = ClientDesignDependency(from)
    override def asInternal(from: ClientDesignDependency): DesignDependency = from._internal
  }

  implicit object ExtensionDependencyConverter
      extends BidirectionalMatcher[ExtensionDependency, ClientExtensionDependency] {
    override def asClient(from: ExtensionDependency): ClientExtensionDependency   = ClientExtensionDependency(from)
    override def asInternal(from: ClientExtensionDependency): ExtensionDependency = from._internal
  }

  implicit object ProfileDependencyConverter extends BidirectionalMatcher[ProfileDependency, ClientProfileDependency] {
    override def asClient(from: ProfileDependency): ClientProfileDependency   = ClientProfileDependency(from)
    override def asInternal(from: ClientProfileDependency): ProfileDependency = from._internal
  }

  implicit object ProjectDescriptorConverter extends BidirectionalMatcher[ProjectDescriptor, ClientProjectDescriptor] {
    override def asClient(from: ProjectDescriptor): ClientProjectDescriptor   = ClientProjectDescriptor(from)
    override def asInternal(from: ClientProjectDescriptor): ProjectDescriptor = from._internal
  }

  implicit object GavMatcher extends BidirectionalMatcher[Gav, ClientGav] {
    override def asClient(from: Gav): ClientGav   = ClientGav(from)
    override def asInternal(from: ClientGav): Gav = from._internal
  }

  implicit object MetadataElementMatcher extends BidirectionalMatcher[Metadata, ClientMetadataElement] {
    override def asClient(from: Metadata): ClientMetadataElement   = ClientMetadataElement(from)
    override def asInternal(from: ClientMetadataElement): Metadata = from._internal
  }

  implicit object ProjectDependencyMatcher extends BidirectionalMatcher[ProjectDependency, ClientProjectDependency] {
    override def asClient(from: ProjectDependency): ClientProjectDependency   = ClientProjectDependency(from)
    override def asInternal(from: ClientProjectDependency): ProjectDependency = from._internal
  }

  implicit object DescriptorParseResultMatcher
      extends BidirectionalMatcher[DescriptorParseResult, ClientDescriptorParseResult] {
    override def asClient(from: DescriptorParseResult): ClientDescriptorParseResult = ClientDescriptorParseResult(from)
    override def asInternal(from: ClientDescriptorParseResult): DescriptorParseResult = from._internal
  }

  implicit object ApiInstanceMatcher extends BidirectionalMatcher[Instance, ClientApiInstance] {
    override def asClient(from: Instance): ClientApiInstance = ClientApiInstance(from)

    override def asInternal(from: ClientApiInstance): Instance = from._internal
  }

  implicit object JsonLDObjectWrapperConverter
      extends BidirectionalMatcher[JsonLDObjectWrapper, ClientJsonLDObjectWrapper] {
    override def asClient(from: JsonLDObjectWrapper): ClientJsonLDObjectWrapper = from match {
      case m: Metadata                   => ClientMetadataElement(m)
      case pd: ProjectDescriptor         => ClientProjectDescriptor(pd)
      case dependency: ProjectDependency => ClientProjectDependency(dependency)
      case instance: Instance            => ClientApiInstance(instance)
    }

    override def asInternal(from: ClientJsonLDObjectWrapper): JsonLDObjectWrapper = from._internal
  }
}

object APBProjectConverters extends APBProjectConverters
