package org.mulesoft.apb.project.client.scala.model.management

import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.management.SchemaIris.{
  ANNOTATIONS,
  CORE,
  LABELS,
  MANAGEMENT,
  METADATA,
  NAME,
  NAMESPACE,
  SPEC,
  TARGET_REF
}

import scala.reflect.ClassTag

trait HasName extends HasMetadata {
  def name: String                  = metadata.getScalar[String](NAME)
  def nameIfPresent: Option[String] = metadataIfPresent.flatMap(_.getScalarIfPresent[String](NAME))

  def withName(name: String): this.type = {
    update(METADATA) { metadata =>
      metadata.withProperty(NAME, name)
    }
  }

  def namespace: String = metadata.getScalar[String](NAMESPACE)

  def withNamespace(namespace: String): this.type = {
    update(METADATA) { metadata =>
      metadata.withProperty(NAMESPACE, namespace)
    }
  }
}

trait HasAnnotations extends DynamicObject with HasMetadata {
  def getAnnotation[T <: Any](annotation: String)(implicit ct: ClassTag[T]): T = {
    val annotations = metadata.getObject(ANNOTATIONS)
    annotations.getScalar[T](s"$MANAGEMENT#$annotation")
  }

  def addAnnotation(annotation: String, value: String): this.type = {
    update(METADATA) { metadata =>
      metadata.update(ANNOTATIONS) { annotations =>
        annotations.withProperty(s"$MANAGEMENT#$annotation", value)
      }
    }
  }

  def addAnnotation(annotation: String, value: Int): this.type = {
    update(METADATA) { metadata =>
      metadata.update(ANNOTATIONS) { annotations =>
        annotations.withProperty(s"$MANAGEMENT#$annotation", value)
      }
    }
  }

  def addAnnotation(annotation: String, value: Float): this.type = {
    update(METADATA) { metadata =>
      metadata.update(ANNOTATIONS) { annotations =>
        annotations.withProperty(s"$MANAGEMENT#$annotation", value)
      }
    }
  }

  def addAnnotation(annotation: String, value: Double): this.type = {
    update(METADATA) { metadata =>
      metadata.update(ANNOTATIONS) { annotations =>
        annotations.withProperty(s"$MANAGEMENT#$annotation", value)
      }
    }
  }

  def addAnnotation(annotation: String, value: Boolean): this.type = {
    update(METADATA) { metadata =>
      metadata.update(ANNOTATIONS) { annotations =>
        annotations.withProperty(s"$MANAGEMENT#$annotation", value)
      }
    }
  }
}

trait HasLabels extends DynamicObject with HasMetadata {

  def getLabel[T <: Any](label: String)(implicit ct: ClassTag[T]): T = {
    val labels = metadata.getObject(LABELS)
    labels.getScalar[T](s"$MANAGEMENT#$label")
  }

  def getLabelIfPresent[T <: Any](label: String)(implicit ct: ClassTag[T]): Option[T] = {
    for {
      metadata <- metadataIfPresent
      labels   <- metadata.getObjectIfPresent(LABELS)
      label    <- labels.getScalarIfPresent[T](s"$MANAGEMENT#$label")
    } yield {
      label
    }
  }

  def getStringLabel(label: String): String                  = getLabel[String](label)
  def getStringLabelIfPresent(label: String): Option[String] = getLabelIfPresent[String](label)

  def getIntLabel(label: String): Int                  = getLabel[Int](label)
  def getIntLabelIfPresent(label: String): Option[Int] = getLabelIfPresent[Int](label)

  def addLabel(label: String, value: String): this.type = {
    update(METADATA) { metadata =>
      metadata.update(LABELS) { labels =>
        labels.withProperty(s"$MANAGEMENT#$label", value)
      }
    }
  }

  def addLabel(label: String, value: Int): this.type = {
    update(METADATA) { metadata =>
      metadata.update(LABELS) { labels =>
        labels.withProperty(s"$MANAGEMENT#$label", value)
      }
    }
  }

  def addLabel(label: String, value: Float): this.type = {
    update(METADATA) { metadata =>
      metadata.update(LABELS) { labels =>
        labels.withProperty(s"$MANAGEMENT#$label", value)
      }
    }
  }

  def addLabel(label: String, value: Double): this.type = {
    update(METADATA) { metadata =>
      metadata.update(LABELS) { labels =>
        labels.withProperty(s"$MANAGEMENT#$label", value)
      }
    }
  }

  def addLabel(label: String, value: Boolean): this.type = {
    update(METADATA) { metadata =>
      metadata.update(LABELS) { labels =>
        labels.withProperty(s"$MANAGEMENT#$label", value)
      }
    }
  }
}

trait HasSpec extends DynamicObject {
  def spec: DynamicObject = {
    val spec = getObject(SPEC)
    spec
  }

  def specIfPresent: Option[DynamicObject] = {
    val spec = getObjectIfPresent(SPEC)
    spec
  }
}

trait HasMetadata extends DynamicObject {
  def metadata: DynamicObject = {
    val metadata = getObject(METADATA)
    metadata
  }

  def metadataIfPresent: Option[DynamicObject] = {
    getObjectIfPresent(METADATA)
  }
}

trait HasTargetRef extends HasMetadata with HasSpec {
  def getTargetRefName: Option[String] =
    spec.getObjectIfPresent(TARGET_REF).flatMap(o => o.getScalarIfPresent[String](NAME))

  def hasTarget: Boolean = getTargetRefName.isDefined
  def targetRef: NamedRefWithKind = {
    val ref = spec.getObject(TARGET_REF)
    NamedRefWithKind(ref.internal)
  }

  def withTargetRef(name: String): this.type = {
    update(SPEC) { spec =>
      spec.withProperty(TARGET_REF, NamedRef(name, TARGET_REF))
    }
  }

  def withTargetRef(name: String, kind: String): this.type = {
    update(SPEC) { spec =>
      spec.withProperty(TARGET_REF, NamedRefWithKind(name, kind, TARGET_REF))
    }
  }

  protected def hasName(obj: DynamicObject): Boolean = obj.getScalarIfPresent[String](NAME).isDefined
}
