package org.mulesoft.apb.project.client.scala.model

import amf.core.client.scala.model.{DateField, IntField, StrField}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.ProjectDependencyModel._
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptorModel._
import org.mulesoft.common.time.SimpleDateTime

trait ProjectBase extends UnwrappedFields with GavAware {

  private implicit def dependencyConversion(objs: Seq[JsonLDObject]): Seq[ProjectDependency] =
    objs.map(ProjectDependency.apply)

  lazy val name: String                         = get[StrField](ProjectDescriptorModel.Name)
  lazy val gav: Gav                             = getGav
  lazy val classifier: Option[String]           = get[StrField](Classifier)
  lazy val tags: Seq[String]                    = get[Seq[StrField]](Tags)
  lazy val apiVersion: Option[String]           = get[StrField](ApiVersion)
  lazy val organizationId: Option[String]       = get[StrField](OrganizationId)
  lazy val dependencies: Seq[ProjectDependency] = get[Seq[JsonLDObject]](Dependencies)

  lazy val status: Option[String]            = get[StrField](Status)
  lazy val createdAt: Option[SimpleDateTime] = get[DateField](CreatedAt)
  lazy val createdBy: Option[String]         = get[StrField](CreatedBy)
  lazy val updatedAt: Option[SimpleDateTime] = get[DateField](UpdatedAt)
  lazy val customFields: Seq[String]         = get[Seq[StrField]](CustomFields)
  lazy val keyValueTags: Seq[String]         = get[Seq[StrField]](KeyValueTags)
  lazy val tenantId: Option[String]          = get[StrField](TenantId)
  lazy val categories: Seq[String]           = get[Seq[StrField]](Categories)
  lazy val `type`: Option[String]            = get[StrField](TypeField)

  lazy val majorVersionComponent: Option[Int] = get[IntField](MajorVersionComponent)
  lazy val minorVersionComponent: Option[Int] = get[IntField](MinorVersionComponent)
  lazy val patchVersionComponent: Option[Int] = get[IntField](PatchVersionComponent)

  private def getGav: Gav = {
    val groupId: String = get[StrField](GroupId)
    val assetId: String = get[StrField](AssetId)
    val version: String = get[StrField](Version)
    Gav(groupId, assetId, version)
  }
}
