package org.mulesoft.apb.project.client.scala.model.management

import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.instances.APIInstanceModel.ENVIRONMENT_TERM
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.management.SchemaIris.{ENVIRONMENT_KIND, SPEC}

case class Environment(override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with HasMetadata
    with HasLabels
    with HasAnnotations
    with HasName
    with HasSpec {

  def kind: String = spec.getScalar[String](ENVIRONMENT_KIND)

  def withKind(kind: String): this.type = {
    update(SPEC) { spec =>
      spec.withProperty(ENVIRONMENT_KIND, kind)
    }
  }
}

object Environment {

  def apply(name: String): Environment = {
    val path  = JsonPath.empty
    val model = JsonLDEntityModel(List(ENVIRONMENT_TERM), Nil, path)
    val init  = JsonLDObject.empty(model, path)
    new Environment(init)
      .withProperty("http://a.ml/vocabularies/core#apiVersion", Constants.apiVersion)
      .withProperty("http://a.ml/vocabularies/core#kind", Constants.environmentKind)
      .withName(name)
  }
}
