package org.mulesoft.apb.project.client.platform.model.management
import org.mulesoft.apb.project.client.scala.model.management.{HasName => InternalHasName, HasAnnotations => InternalHasAnnotations, HasLabels => InternalHasLabels}
import scala.scalajs.js.annotation.JSExportAll

@JSExportAll
trait HasName {
  private[apb] val internal: InternalHasName
  def name: String = internal.name

  def withName(name: String): this.type = {
    internal.withName(name)
    this
  }
}

@JSExportAll
trait HasAnnotations {
  private[apb] val internal: InternalHasAnnotations

  def getStringAnnotation(annotation: String): String   = internal.getAnnotation[String](annotation)
  def getIntAnnotation(annotation: String): Int         = internal.getAnnotation[Int](annotation)
  def getFloatAnnotation(annotation: String): Float     = internal.getAnnotation[Float](annotation)
  def getDoubleAnnotation(annotation: String): Double   = internal.getAnnotation[Double](annotation)
  def getBooleanAnnotation(annotation: String): Boolean = internal.getAnnotation[Boolean](annotation)

  def addAnnotation(annotation: String, value: String): this.type = {
    internal.addAnnotation(annotation, value)
    this
  }

  def addAnnotation(annotation: String, value: Int): this.type = {
    internal.addAnnotation(annotation, value)
    this
  }

  def addAnnotation(annotation: String, value: Float): this.type = {
    internal.addAnnotation(annotation, value)
    this
  }

  def addAnnotation(annotation: String, value: Double): this.type = {
    internal.addAnnotation(annotation, value)
    this
  }

  def addAnnotation(annotation: String, value: Boolean): this.type = {
    internal.addAnnotation(annotation, value)
    this
  }
}

@JSExportAll
trait HasLabels {
  private[apb] val internal: InternalHasLabels
  def getStringLabel(label: String): String   = internal.getLabel[String](label)
  def getIntLabel(label: String): Int         = internal.getLabel[Int](label)
  def getFloatLabel(label: String): Float     = internal.getLabel[Float](label)
  def getDoubleLabel(label: String): Double   = internal.getLabel[Double](label)
  def getBooleanLabel(label: String): Boolean = internal.getLabel[Boolean](label)

  def addLabel(label: String, value: String): this.type = {
    internal.addLabel(label, value)
    this
  }

  def addLabel(label: String, value: Int): this.type = {
    internal.addLabel(label, value)
    this
  }

  def addLabel(label: String, value: Float): this.type = {
    internal.addLabel(label, value)
    this
  }

  def addLabel(label: String, value: Double): this.type = {
    internal.addLabel(label, value)
    this
  }

  def addLabel(label: String, value: Boolean): this.type = {
    internal.addLabel(label, value)
    this
  }
}
