package org.mulesoft.apb.project.internal.idadoption

import amf.aml.internal.metamodel.document.DialectModel
import amf.core.client.scala.adoption.{DefaultIdMaker, IdAdopter, IdAdopterProvider, IdMaker}
import amf.core.client.scala.model.domain.{AmfElement, AmfObject}
import amf.core.internal.parser.domain.FieldEntry
import amf.shapes.internal.document.metamodel.JsonLDInstanceDocumentModel

object IdAdopterProvider extends IdAdopterProvider {
  override def idAdopter(initialId: String): IdAdopter = new APBIdAdopter(initialId)

  override def idAdopter(initialId: String, idMaker: IdMaker): IdAdopter = new APBIdAdopter(initialId)
}

class APBIdAdopter(initialId: String) extends IdAdopter(initialId, new APBIdMaker()) {

  override def adoptFromRoot(initialElem: AmfObject): Unit = {
    super.adoptFromRoot(initialElem)
    initialElem.withId(initialId + "/document")
  }
}

class APBIdMaker extends DefaultIdMaker {

  override def makeArrayElementId(parent: String, index: Int, element: AmfElement): String = {
    super.makeArrayElementId(parent, index, element).stripSuffix("/")
  }

  override def makeId(parent: AmfObject, field: FieldEntry, isRoot: Boolean): String = {
    if (field.field == JsonLDInstanceDocumentModel.Encodes || field.field == DialectModel.Encodes)
      parent.id.stripSuffix("/") + "#" // TODO: ideally use super.withFragment but is private, chage for next release.
    else super.makeId(parent, field, isRoot)
  }
}
