package org.mulesoft.apb.project.internal.idadoption

object URITools {

  implicit class URIStr(str: String) {
    def hasProtocol: Boolean =
      str.startsWith("file://") || str.startsWith("http://") || str.startsWith("https://") || str.startsWith("urn")

    def withProtocol: String = "file://" + str
    def indexed(index: Int): String = {
      if (str.contains(".")) indexedWithExtension(index)
      else str + "/" + index
    }

    private def indexedWithExtension(index: Int) = {
      val extension = str.substring(str.lastIndexOf("."))
      str.stripSuffix(extension) + "/" + index + extension
    }
  }
}
