package org.mulesoft.apb.project.internal.listener

import amf.core.client.scala.config.{AMFEvent, AMFEventListener, FoundReferencesEvent}
import amf.core.client.scala.errorhandling.AMFErrorHandler
import amf.core.client.scala.parse.document.Reference

trait RawReferenceListener extends AMFEventListener {
  override def notifyEvent(event: AMFEvent): Unit = event match {
    case fr: FoundReferencesEvent =>
      checkReferences(fr.references, fr.rootLocation, fr.eh)
    case _ => // ignore
  }

  protected def checkReferences(references: Seq[Reference], location: String, eh: AMFErrorHandler): Unit
}
