package org.mulesoft.apb.project.client.platform.model

import amf.core.client.platform.model.document.BaseUnit
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.{ProjectDocument => InternalProjectDocument}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._
import org.mulesoft.apb.project.client.scala.model.{Project => InternalProject}

class ProjectDocument(private[apb] val _internal: InternalProjectDocument) {

  def this() = this(InternalProjectDocument())

  /** Encoded DomainElement described in the document element. */
  def encodes: ProjectInfo = _internal.encodes

}

case class Project(private[apb] val _internal: InternalProject) {

  def apiContract(): BaseUnit = _internal.apiContract()
  def instances(): ClientList[JsonLDObject] = {
    new InternalSeqOps(_internal.instances())(new IdentityMatcher[JsonLDObject] {}).asClient
  }

  // TODO native-jsonld : add properties of the descriptor
}
