package org.mulesoft.apb.project.internal.idadoption

object URITools {

  implicit class URIStr(str: String) {
    def hasProtocol: Boolean =
      str.startsWith("file://") || str.startsWith("http://") || str.startsWith("https://") || str.startsWith("urn")

    def withProtocol: String                      = "file://" + str
    def indexed(index: Int, kind: String): String = withSufix(kind + "/" + index)

    private def sufixWithExtension(sufix: String) = {
      val extension = str.substring(str.lastIndexOf("."))
      str.stripSuffix(extension) + "/" + sufix + extension
    }

    def forKind(kind: String): String = withSufix(kind)

    private def withSufix(sufix: String) = {
      if (str.contains(".")) sufixWithExtension(sufix)
      else str + "/" + sufix
    }
  }
}
