package org.mulesoft.apb.project.internal.view

import amf.core.client.scala.model.domain.{AmfObject, DomainElement}
import Views.descriptorView
import org.mulesoft.apb.project.client.scala.model.ProjectInfo

object ProjectView {
  def apply(project: ProjectInfo): ModelView[ProjectInfo] = {
    ProjectInfoView(project, CustomizableModelView(descriptorView, AsIsElementCopier))
  }
}

case class ProjectInfoView(project: ProjectInfo, inner: ModelView[AmfObject]) extends ModelView[ProjectInfo] {
  override def view(element: AmfObject): ProjectInfo = {
    val copy = inner.view(element)
    copy.fields.into(project.fields)
    project
  }
}
