package org.mulesoft.apb.project.client.scala.descriptor

import amf.core.internal.metamodel.Field
import amf.core.internal.render.emitters.{EntryEmitter, PartEmitter}
import amf.shapes.client.scala.config.JsonLDSchemaConfiguration
import amf.shapes.client.scala.render.{JsonLDObjectRender, SyntaxProvider, TermNameSyntaxProvider}
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptor
import org.yaml.model.YDocument
import org.yaml.render.JsonRender

object APBDescriptorRender {

  def render(descriptor: ProjectDescriptor): String = {
    val emitter = new JsonLDObjectRender(descriptor.wrapped, DescriptorTermNameSyntaxProvider)
    render(emitter)
  }

  private def render(emitter: PartEmitter) = {
    val document = YDocument { b =>
      emitter.emit(b)
    }
    JsonRender.render(document.node)
  }

  object DescriptorTermNameSyntaxProvider extends SyntaxProvider {
    override def keyFor(clazz: String, property: String): String = {
      property
        .split('#')
        .lastOption
        .collect {
          case "dependency"    => "dependencies"
          case "instance"      => "instances"
          case "semverVersion" => "version"
        }
        .getOrElse(TermNameSyntaxProvider.keyFor(clazz, property))
    }
  }
}
