package org.mulesoft.apb.project.client.scala.model

import amf.aml.client.scala.model.domain.DialectDomainElement
import amf.core.client.scala.model.StrField
import amf.core.client.scala.model.domain.{AmfObject, AmfScalar, Graph}
import amf.core.client.scala.vocabulary.Namespace.Data
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Type.Str
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.metamodel.{Field, ModelDefaultBuilder, Obj}
import amf.core.internal.parser.domain.{Annotations, Fields}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.MetadataModel.{BranchId, CommitId, ProjectId, entityModel}
import org.mulesoft.apb.project.internal.ops.FieldsOps

object MetadataModel {

  val BranchId  = Field(Str, Data + "branchId", doc("branchId"))
  val CommitId  = Field(Str, Data + "commitId", doc("commitId"))
  val ProjectId = Field(Str, Data + "projectId", doc("projectId"))

  val `type`: List[ValueType] = List(Data + "Metadata")
  val fields: List[Field]     = List(BranchId, CommitId, ProjectId)

  private def doc(name: String) = ModelDoc(displayName = name)

  val entityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}

object Metadata {
  def apply(): Metadata = Metadata(JsonLDObject.empty(entityModel, JsonPath.empty))
}
case class Metadata(override private[apb] val wrapped: JsonLDObject) extends JsonLDObjectWrapper with UnwrappedFields {

  override type This = Metadata

  override protected def fields: Fields = wrapped.fields

  def branchId: Option[String]  = get[StrField](BranchId)
  def commitId: Option[String]  = get[StrField](CommitId)
  def projectId: Option[String] = get[StrField](ProjectId)

  def withBranchId(branchId: String): Metadata = {
    wrapped.withProperty(BranchId, branchId)
    this
  }

  def withCommitId(commitId: String): Metadata = {
    wrapped.withProperty(CommitId, commitId)
    this
  }

  def withProjectId(projectId: String): Metadata = {
    wrapped.withProperty(ProjectId, projectId)
    this
  }
}
